<?php
##======================================================##
##  365 FAQ                                             ##
##  Copyright (C) php365.com All rights reserved.       ##
##  http://php365.com/                                  ##
##======================================================##
// デフォルト設定ライブラリ
require_once("./lib/config.php");
// データベース操作ライブラリ
require_once(PATH_LIB.DBSTR.".php");
// 共通仕様サブルーチン
require_once(PATH_LIB."common.php");
#--------------------------------------------------------#

decode();
search();
exit;
#------------------#
#  キーワード検索  #
#------------------#
function search(){
	global $title,$url,$config_arr;

	if(empty($_GET['kw'])){	error("キーワードが入力されていません、LINE=".__LINE__); }

	if(isset($_GET['p']) && intval($_GET['p']) > 0){
		$pagenow = intval($_GET['p']);
	}else{
		$pagenow = 1;
	}

	$_GET['kw'] = mb_ereg_replace("(\s|　)+", " ", $_GET['kw']);
	$keyword_input = $_GET['kw'];
	$keyword_encoded = rawurlencode($_GET['kw']);
	$keywords = array();
	$keywords = split(" ", $_GET['kw']);
	if(count($keywords) == 0){	error("キーワードが入力されていません、LINE=".__LINE__); }
	if(count($keywords) > 3){	error("指定できるキーワードは3つまでです、LINE=".__LINE__); }

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	// Referer（リファラー）チェック
	check_referer($config_arr['flag_referer']);

	foreach(array('title', 'url') as $key){	$$key = $config_arr[$key]; }

	$num_start = ($pagenow - 1) * $config_arr['pageview'] + 1;

	do_search($db,$keywords,$pagenow,$num_start,$keyword_encoded,$config_arr['order'],$config_arr['pageview']);
}
#------------#
#  検索処理  #
#------------#
function do_search(&$db,&$keywords,&$pagenow,&$num_start,&$keyword_encoded,$order,$pageview){

	$time_start = get_microtime();
	$offset = $num_start - 1;
	$sql = "SELECT count(*) FROM ".DBPREFIX."master";
	$where = "";
	$keyword_input = "";
	for($i = 0; $i < count($keywords); $i++){
		if(empty($keywords[$i])){	continue; }
		if(strlen($keywords[$i]) > 32){	error("キーワードが長すぎます、LINE=".__LINE__); }
		if($i == 0 || empty($where)){
			$where = " WHERE ";
			$keyword_input = $keywords[$i];
		}else{
			$where .= " AND ";
			$keyword_input .= " " . $keywords[$i];
		}
		$keyword4sql = $db->escape_string(t2h($keywords[$i]));
		$where .= "(question LIKE '%${keyword4sql}%' OR answer LIKE '%${keyword4sql}%')";
	}
	$sql .= $where;
	$sql_tmp = $sql;
	if(isset($_GET['ct']) && preg_match('/^[0-9]{6}$/', $_GET['ct'])){
		$sql .= " AND ct_cd LIKE '".substr($_GET['ct'], 0, 2)."%'";
		$ct_name = get_name_category($db,$_GET['ct']);
	}else{
		$ct_name = "";
	}
	$rows_all = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	$ct_cnt_arr = array();
	$ct_cnt_arr = get_count_item_for_ct($db,$sql_tmp);
	if($rows_all > 0){
		$sql = str_replace("SELECT count(*) FROM", "SELECT * FROM", $sql);
		$sort = intval($order) < 1 ? "" : " DESC";
		$sql .= " ORDER BY id ".$sort." limit ${offset}, ".$pageview;
		$items = $db->get_rows($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	}
	show_tmpl_pages($db,$items,$keywords,$rows_all,$pagenow,$num_start,$keyword_input,$order,$sort,$keyword_encoded,$time_start,$ct_cnt_arr,$ct_name);
}
#----------------------------------#
#  検索結果件数をカテゴリ毎に取得  #
#----------------------------------#
function get_count_item_for_ct(&$db,$sql){

	$arr = array();
	$sql = str_replace("SELECT count(*) FROM", "SELECT ct_cd FROM", $sql);
	$items = $db->get_rows($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	foreach($items as $item){
		$ct_cd_top = substr($item['ct_cd'], 0, 2);
		if(array_key_exists($ct_cd_top, $arr)){
			$ct_cnt = $arr[$ct_cd_top];
		}else{
			$ct_cnt = 0;
		}
		$ct_cnt++;
		$arr[$ct_cd_top] = $ct_cnt;
	}
	unset($items);
	return $arr;
}
#--------------------------------------#
#  テンプレート -> 検索結果ページ表示  #
#---------------------------------------#
function show_tmpl_pages(&$db,&$items,&$keywords,&$rows_all,&$pagenow,&$num_start,&$keyword_input,&$order,&$sort,&$keyword_encoded,&$time_start,$ct_cnt_arr=array(),&$ct_name){
	global $CNF,$title,$url,$config_arr;

	$faq_detail = "";
if($rows_all > 0){
	foreach($items as $item){
		if($item['status'] == 0){	continue; }
		$question = $item['question'];
		for($i = 0; $i < count($keywords); $i++){
			foreach(array('question', 'answer') as $key){
				$item[$key] = str_replace($keywords[$i], "<strong>".$keywords[$i]."</strong>", $item[$key]);
				$kw_upper = strtoupper($keywords[$i]);
				$item[$key] = str_replace($kw_upper, "<strong>".$kw_upper."</strong>", $item[$key]);
			}
		}
		$faq_detail .= "<a name=\"${item['id']}\"></a>\n";
		$faq_detail .= "<dt>Q.${item['question']}</dt>\n";
		$faq_detail .= "<dd>A.${item['answer']}\n";
		$sql = "SELECT count(*) FROM ".DBPREFIX."tags WHERE id = ${item['id']}";
		$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		if($rows > 0){
		$sql = "SELECT tag FROM ".DBPREFIX."tags WHERE id = ${item['id']} ORDER BY id";
		$items_tags = $db->get_rows($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		$cnt = 0;
		foreach($items_tags as $item_tags){
			if(empty($item_tags['tag'])){	continue; }
			$cnt++;
			if($cnt == 1){	$faq_detail .= "<br><br>関連タグ：\n"; }
			$faq_detail .= "<a href=\"".t2h($_SERVER['SCRIPT_NAME'])."?mode=tag&tag=".rawurlencode($item_tags['tag'])."\">".t2h($item_tags['tag'])."</a>&nbsp;\n";
		}
		}
		$faq_detail .= "</dd>\n";
	}
}
	// カテゴリリスト取得
	$list_top_category = get_list_top_category_for_search($db,$ct_cnt_arr,$keyword_encoded);

	// タグリスト取得
	$list_tags = get_list_tags($db,$config_arr['tag_num']);

	$db->close();

	if($rows_all < $pagenow * $config_arr['pageview']){
		$num_end = $rows_all;
	}else{
		$num_end = $pagenow * $config_arr['pageview'];
	}
	foreach(array('rows_all', 'num_start', 'num_end') as $key){
		$key_new = $key . "_format";
		$$key_new = str_replace(",", "&#44;", number_format($$key));
	}
	$argv = t2h($_SERVER['SCRIPT_NAME'])."?mode=search&kw=${keyword_encoded}";
	$pageing = $num_start_format."&nbsp;-&nbsp;".$num_end_format."&nbsp;(&nbsp;".$rows_all_format."&nbsp;件中&nbsp;)<br><br>\n";
	$pages_str = get_control_pages($rows_all,$pagenow,$num_start,$num_end,"seek",$argv,$pageing,$config_arr['pageview'],$config_arr['page_control']);
	$keyword_input4html = t2h($keyword_input);

	if($rows_all > 0){
		$time_end = get_microtime();
		$time = $time_end - $time_start;
		$time = t2h(round($time, 2));
		$pagectl_details = "<b>${keyword_input4html}</b>の検索結果&nbsp;&nbsp;<b>${rows_all_format}</b>&nbsp;件中&nbsp;<b>${num_start_format}</b>&nbsp;-&nbsp;<b>${num_end_format}</b>&nbsp;件目&nbsp;(<b>${time}</b>&nbsp;秒)&nbsp;";
	}else{
		$pagectl_details = "<b>${keyword_input4html}</b>の検索結果&nbsp;&nbsp;<b>${rows_all_format}</b>&nbsp;件";
	}

	require(PATH_TEMPLATE."search.html");
}
#----------------#
#  デコード処理  #
#----------------#
function decode(){

	if($_SERVER['REQUEST_METHOD'] == "POST"){	error("不正な投稿です、LINE=".__LINE__); }

	foreach($_GET as $key => $value){
		// バックスラッシュの排除
		if(get_magic_quotes_gpc()){	$value = stripslashes($value); }

		if($key == "kw"){	$value = rawurldecode($value); }

		$value = strip_tags($value);
		$value = preg_replace('/[\r\n\t\0]/', '', $value);
		$value = preg_replace('/style[^=]*=/i', '', $value);
		$value = preg_replace('/on(Blur|Change|Click|Focus|Load|Mouse|Select|Submit|Reset|Unload)[^=]*=/i', '', $value);
		$value = trim($value);
		$_GET[$key] = $value;
	}
}
#------------------#
#  マイクロ秒取得  #
#------------------#
function get_microtime(){

	list($msec, $sec) = explode(" ", microtime());
	return ((float)$msec + (float)$sec);
}
#----------------------#
#  カテゴリリスト取得  #
#----------------------#
function get_list_top_category_for_search(&$db,&$ct_cnt_arr,&$keyword_encoded){
	global $CNF,$ct_name;

	$str = "";
	$ct_name = "";
	$sql = "SELECT count(*) FROM ".DBPREFIX."category WHERE ct_cd like '%0000'";
	$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	if($rows > 0){
	$sql = "SELECT ct_cd,ct_name FROM ".DBPREFIX."category WHERE ct_cd like '%0000' ORDER BY ct_cd";
	$items = $db->get_rows($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	foreach($items as $item){
		$ct_cd_top = substr($item['ct_cd'], 0, 2);
		if(array_key_exists($ct_cd_top, $ct_cnt_arr)){
			$rows = $ct_cnt_arr[$ct_cd_top];
		}else{
			$rows = 0;
		}
		$str .= "<li><a href=\"${CNF['search']}?mode=search&kw=${keyword_encoded}&ct=${item['ct_cd']}\">".t2h($item['ct_name'])."</a>&nbsp;(".number_format($rows).")</li>\n";
	}
	}

	if(!empty($str)){	$str = "<ul>\n" . $str . "</ul>\n"; }
	return $str;
}
#---------------------------------#
#  Referer（リファラー）チェック  #
#---------------------------------#
function check_referer($flag){

	if(!$flag){	return; }
	$referer_url = getenv("HTTP_REFERER");
	$path_arr = pathinfo($referer_url);
	$pattern = '/^'. preg_quote($path_arr['dirname'], '/') .'/';
	$parse_arr = parse_url($referer_url);
	$target = $parse_arr['scheme']."://".$_SERVER["HTTP_HOST"] . $_SERVER["SCRIPT_NAME"];
	if(!preg_match($pattern, $target)){	error("アクセス経路が不正です、LINE=".__LINE__); }
}
?>