<?php
##======================================================##
##  365 FAQ セットアップ                                ##
##  Copyright (C) php365.com All rights reserved.       ##
##  http://php365.com/                                  ##
##======================================================##
// デフォルト設定ライブラリ
require_once("./lib/config.php");
// 共通仕様サブルーチン
require_once(PATH_LIB."common.php");
// データベース操作ライブラリ
require_once(PATH_LIB.DBSTR.".php");
// テーブル定義
if(DBSTR == "mysql"){
	require_once(PATH_LIB."define_table_".DBSTR.".php");
}else{
	require_once(PATH_LIB."define_table_sqlite.php");
}

setup();
exit;
##======================================================##
##  セットアップ                                        ##
##======================================================##
function setup(){

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);
	if(DBSTR == "mysql"){
		$version = $db->check_version();
		$ver_arr = split("\.", $version);
		if(intval($ver_arr[0]) >= 5 && intval($ver_arr[1]) >= 5){
			$flag_storage_engine = true;
		}else{
			$flag_storage_engine = false;
		}
	}else{
		$flag_storage_engine = true;
	}
	$result = $db->transaction_begin();

	$tb_names = $db->list_tables(DBNAME);

	// 設定テーブルチェック
	check_config($db,$tb_names);

	// テーブル作成（category,master,tags）
	setup_tables($db,$tb_names,$flag_storage_engine);

	// 初期設定インポート
	import_config($db,$tb_names,$flag_storage_engine);

	$result = $db->transaction_commit();
	$db->close();
	$msg_title = "セットアップ完了しました。";
	$msg_com = "セットアップ完了しました。<font color=\"red\">setup.php</font>は、すぐに削除して下さい。";
	message($msg_title,$msg_com);
}
##======================================================##
##  テーブル作成                                        ##
##======================================================##
function setup_tables(&$db,&$tb_names,&$flag_storage_engine){
	global $CNF,$define_category,$define_master,$define_tags,$index_sql_arr;

	foreach(array('category', 'master', 'tags') as $key){
		if(in_array(DBPREFIX.$key, $tb_names)){
			error("テーブル：".DBPREFIX.$key."は作成済みです。 LINE=".__LINE__);
		}
		$define = "define_".$key;
		if(DBSTR == "mysql" && !$flag_storage_engine){	$$define = str_replace("ENGINE=", "TYPE=", $$define); }
		$sql = "CREATE TABLE ".DBPREFIX.$key.$$define;
		$result = $db->query($sql);
	}
	if((intval(DBTYPE) == 2 || intval(DBTYPE) == 3) && is_array($index_sql_arr)){
		for($i = 0; $i < count($index_sql_arr); $i++){
			$sql = str_replace("DBPREFIX", DBPREFIX, $index_sql_arr[$i]);
			$result = $db->query($sql);
		}
	}
}
##======================================================##
##  設定テーブルチェック                                ##
##======================================================##
function check_config(&$db,&$tb_names){
	global $CNF,$define_config;

	if(in_array(DBPREFIX."config", $tb_names)){
		$sql = "SELECT count(*) FROM ".DBPREFIX."config WHERE kw='version'";
		$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		if($rows == 0){	error("テーブル：".DBPREFIX."config"."のバージョン情報が参照できませんでした。 LINE=".__LINE__); }
		$sql = "SELECT value FROM ".DBPREFIX."config WHERE kw='version'";
		$item = $db->fetch_array_assoc($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		if($CNF['version'] == $item['value']){
			error("Ver.${CNF['version']}は既にセットアップ済みです。<br>設置し直す場合は、".DBSTR."のテーブルを削除してから再度setup.phpを実行して下さい。 LINE=".__LINE__);
		}else{
			error("別のバージョンのテーブル：".DBPREFIX."config"."が作成済みです。 LINE=".__LINE__);
		}
	}
}
##======================================================##
##  初期設定インポート                                  ##
##======================================================##
function import_config(&$db,&$tb_names,&$flag_storage_engine){
	global $CNF,$define_config;

	if(DBSTR == "mysql" && !$flag_storage_engine){	$define_config = str_replace("ENGINE=", "TYPE=", $define_config); }
	$sql = "CREATE TABLE ".DBPREFIX."config ".$define_config;
	$result = $db->query($sql);
	foreach($CNF as $key => $value){
		if($key == "pass"){	$value = sha1($value); }
		foreach(array('key', 'value') as $k){	$$k = $db->escape_string($$k); }
		$line = "NULL,'${key}','${value}'";
		$sql = "INSERT INTO ".DBPREFIX."config VALUES ($line)";
		$result = $db->query($sql);
	}
}
##======================================================##
##  メッセージ出力                                      ##
##======================================================##
function message($msg_title,$msg_com){
	global $CNF;

echo <<<EOM
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html lang="ja">
<head>
<meta http-equiv="Content-Language" content="ja">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>${msg_title}</title>
</head>
<body><center>
<h4>${msg_title}</h4>
<p>${msg_com}</p>
<p>まず、管理画面にログインしてパスワードを設定して下さい。
<br>初期パスワードは、<font color="red">setup</font> です。<br>
<br><a href="${CNF['main']}?mode=login">管理画面へ</a></p>
<br><p><a href="${CNF['url']}">ホーム</a></p>
</center>
</body>
</html>
EOM;
exit;
}
?>