<?php
##======================================================##
##  365 FAQ                                             ##
##  Copyright (C) php365.com All rights reserved.       ##
##  http://php365.com/                                  ##
##======================================================##
// デフォルト設定ライブラリ
require_once("./lib/config.php");
// データベース操作ライブラリ
require_once(PATH_LIB.DBSTR.".php");
// 共通仕様サブルーチン
require_once(PATH_LIB."common.php");
#--------------------------------------------------------#

switch($_SERVER['REQUEST_METHOD']):
	case 'GET':
		if(!isset($_GET['mode'])){	login(true);exit; }
		switch($_GET['mode']):
			case 'entry':		// FAQ登録画面表示
				entry();
				break;
			case 'category':
				show_category();
				break;
			case 'add_category':
				show_add_category();
				break;
			case 'modify_category':
				show_modify_category();
				break;
			case 'delete_category':
				show_delete_category();
				break;
			case 'modify_order':
				show_modify_order();
				break;
			case 'search':
				show_search();
				break;
			case 'modify_pass':
				show_modify_pass();
				break;
			case 'env':
				show_env();
				break;
			case 'color':
				show_color();
				break;
			case 'modify':
				show_modify();
				break;
			case 'delete':
				show_delete();
				break;
			case 'list_category':
				show_list_category();
				break;
			case 'faq_all':
				show_faq_all();
				break;
			case 'logout':	// ログアウト
				logout();
				break;
			default:
				login(true);
				break;
		endswitch;
		break;
	case 'POST':
		if(!isset($_POST['mode'])){	error("不正なリクエストです、LINE=".__LINE__);exit; }
		switch($_POST['mode']):
			case 'do_entry':
				$motion = rawurldecode($_POST['motion']);
				switch($motion):
					case 'プレビュー':
						preview();
						break;
					case '登録':
						decode();
						do_entry();
						break;
					default:
						error("不正なリクエストです、LINE=".__LINE__);
						break;
				endswitch;
				break;
			case 'do_modify':
				$motion = rawurldecode($_POST['motion']);
				switch($motion):
					case 'プレビュー':
						preview("modify");
						break;
					case '変更する':
						decode();
						do_modify();
						break;
					default:
						error("不正なリクエストです、LINE=".__LINE__);
						break;
				endswitch;
				break;
			case 'do_add_category':
				decode();
				do_add_category();
				break;
			case 'do_modify_category':
				decode();
				do_modify_category();
				break;
			case 'do_delete_category':
				decode();
				do_delete_category();
				break;
			case 'do_modify_order':
				decode();
				do_modify_order();
				break;
			case 'do_modify_pass':
				decode();
				do_modify_pass();
				break;
			case 'do_env':
				decode();
				do_env();
				break;
			case 'do_delete':
				decode();
				do_delete();
				break;
			case 'login':	// ログイン
				login();
				break;
			default:
				error("不正なリクエストです、LINE=".__LINE__);
				break;
		endswitch;
		break;
	default:
		error("不正なリクエストです、LINE=".__LINE__);
		break;
endswitch;
exit;
#------------------------#
#  カテゴリ管理画面表示  #
#------------------------#
function show_list_category(){
	global $CNF;

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	check_user_cookie($CNF['cookie_name'],$config_arr['pass']);

	foreach(array('title', 'url') as $key){	$$key = $config_arr[$key]; }

	// カテゴリ一覧取得
	$list_category_all = get_list_category_all($db);

	$db->close();
	require(PATH_TEMPLATE."show_list_category.html");
}
#------------------------#
#  カテゴリ管理画面表示  #
#------------------------#
function show_category(){
	global $CNF;

	if(isset($_GET['ct_parent']) && $_GET['ct_parent'] != "" && !preg_match('/^[0-9]{6}$/', $_GET['ct_parent'])){
		error("親カテゴリが不正がです、LINE=".__LINE__);
	}
	$ct_parent = (isset($_GET['ct_parent']) &&preg_match('/^[0-9]{6}$/', $_GET['ct_parent'])) ? $_GET['ct_parent'] : "";

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	check_user_cookie($CNF['cookie_name'],$config_arr['pass']);

	foreach(array('title', 'url') as $key){	$$key = $config_arr[$key]; }

	// カテゴリselect_box取得
	$ct_select_box = get_ct_select_box($db,"show",$ct_parent);

	// カテゴリ一覧取得
	$list_category = get_list_category($db,$ct_parent);

	$db->close();
	require(PATH_TEMPLATE."show_category.html");
}
#-------------------#
#  FAQ管理画面表示  #
#-------------------#
function show_search(){
	global $CNF;

	if(isset($_GET['ct_parent']) && $_GET['ct_parent'] != "" && !preg_match('/^[0-9]{6}$/', $_GET['ct_parent'])){
		error("親カテゴリが不正がです、LINE=".__LINE__);
	}
	$ct_parent = (isset($_GET['ct_parent']) && preg_match('/^[0-9]{6}$/', $_GET['ct_parent'])) ? $_GET['ct_parent'] : "";

if(isset($_GET['kw']) && $_GET['kw'] != ""){
	if(get_magic_quotes_gpc()){	$_GET['kw'] = stripslashes($_GET['kw']); }
	$_GET['kw'] = trim($_GET['kw']);
	$_GET['kw'] = strip_tags($_GET['kw']);
	$_GET['kw'] = preg_replace('/[\n\r\t\0]/', '', $_GET['kw']);
	$_GET['kw'] = preg_replace('/style[^=]*=/i', '', $_GET['kw']);
	$_GET['kw'] = preg_replace('/on(Blur|Change|Click|Focus|Load|Mouse|Select|Submit|Reset|Unload)[^=]*=/i', '', $_GET['kw']);
	$_GET['kw'] = mb_ereg_replace("(\s|　)+", " ", $_GET['kw']);
	$keywords = split(" ", $_GET['kw']);
	if(count($keywords) > 3){	error("指定できるキーワードは3つまでです、LINE=".__LINE__); }
	$keyword_encoded = rawurlencode($_GET['kw']);
}else{
	$_GET['kw'] = "";
	$keyword_encoded = "";
}
	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	check_user_cookie($CNF['cookie_name'],$config_arr['pass']);

	foreach(array('title', 'url') as $key){	$$key = $config_arr[$key]; }

	// カテゴリselect_box取得
	$ct_select_box = get_ct_select_box($db,"",$ct_parent);

	if(isset($_GET['p']) && intval($_GET['p']) > 0){
		$pagenow = intval($_GET['p']);
	}else{
		$pagenow = 1;
	}
	$num_start = ($pagenow - 1) * $config_arr['pageview'] + 1;
	$offset = $num_start - 1;

	$where = "";
	if(!empty($ct_parent)){	$where = " ct_cd = '${ct_parent}'"; }
	if(!empty($keywords)){
		for($i = 0; $i < count($keywords); $i++){
			if(empty($keywords[$i])){	continue; }
			if(strlen($keywords[$i]) > 32){	error("キーワードが長すぎます、LINE=".__LINE__); }
			if(!empty($where)){	$where .= " AND "; }
			$Keyword = $db->escape_string($keywords[$i]);
			$where .= "question LIKE '%${Keyword}%'";
		}
	}
	if(!empty($where)){	$where = "WHERE " . $where; }
	$sql = "SELECT count(*) FROM ".DBPREFIX."master ${where}";
	$rows_all = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	if($rows_all > 0){
		$sql = str_replace("count(*)", "*", $sql);
		$order = intval($config_arr['order']) > 0 ? " DESC" : "";
		$sql .= " ORDER BY ct_cd, id${order} limit ${offset}, ${config_arr['pageview']}";
		$items = $db->get_rows($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);

		// FAQ一覧取得
		$list_faq = get_list_faqs_for_admin($db,$items,$ct_parent,"");
	}else{
		$list_faq = "";
	}
	if($rows_all < $pagenow * $config_arr['pageview']){
		$num_end = $rows_all;
	}else{
		$num_end = $pagenow * $config_arr['pageview'];
	}
	foreach(array('rows_all', 'num_start', 'num_end') as $key){
		$key_new = $key . "_format";
		$$key_new = str_replace(",", "&#44;", number_format($$key));
	}

	if(!isset($_GET['ct_parent'])){	$_GET['ct_parent'] = ""; }
	$argv = t2h($_SERVER['SCRIPT_NAME'])."?mode=search&ct_parent=${_GET['ct_parent']}&kw=${keyword_encoded}";
	$pageing = $num_start_format."&nbsp;-&nbsp;".$num_end_format."&nbsp;(&nbsp;".$rows_all_format."&nbsp;件中&nbsp;)<br><br>\n";
	$pages_str = get_control_pages($rows_all,$pagenow,$num_start,$num_end,"seek",$argv,$pageing,$config_arr['pageview'],$config_arr['page_control']);

	$db->close();
	require(PATH_TEMPLATE."show_search.html");
}
#--------------------#
#  環境設定画面表示  #
#--------------------#
function show_env(){
	global $CNF;

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	$sql = "SELECT count(*) FROM ".DBPREFIX."config";
	$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	if($rows == 0){	error("環境設定テーブルが参照できませんでした、LINE=".__LINE__); }
	$sql = str_replace("count(*)", "kw,value", $sql);
	$items = $db->get_rows($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);

	foreach($items as $item){	$$item['kw'] = $item['value']; }

	check_user_cookie($CNF['cookie_name'],$pass);

	foreach(array('flag_html', 'order', 'show', 'click', 'show_ct', 'order_tag', 'flag_referer') as $key){
		if(intval($$key) < 1){
			$str = "checked_".$key."_str1";
			$$str = "";
			$str = "checked_".$key."_str0";
			$$str = " checked";
		}else{
			$str = "checked_".$key."_str1";
			$$str = " checked";
			$str = "checked_".$key."_str0";
			$$str = "";
		}
	}

	$db->close();

	require(PATH_TEMPLATE."env.html");
}
#----------------------#
#  カラーパレット表示  #
#----------------------#
function show_color(){
	global $CNF;

	require(PATH_TEMPLATE."show_color.html");
}
#------------------------#
#  カテゴリ追加画面表示  #
#------------------------#
function show_add_category(){
	global $CNF;

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	check_user_cookie($CNF['cookie_name'],$config_arr['pass']);

	foreach(array('title', 'url', 'tag_max') as $key){	$$key = $config_arr[$key]; }

	// カテゴリselect_box取得
	$ct_select_box = get_ct_select_box($db,"parent");

	$db->close();
	require(PATH_TEMPLATE."add_category.html");
}
#------------------------#
#  カテゴリ変更画面表示  #
#------------------------#
function show_modify_category(){
	global $CNF;

	$_GET['id'] = intval($_GET['id']);
	if($_GET['id'] < 1){	error("IDが不正がです、LINE=".__LINE__); }

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	check_user_cookie($CNF['cookie_name'],$config_arr['pass']);

	foreach(array('title', 'url', 'tag_max') as $key){	$$key = $config_arr[$key]; }

	$sql = "SELECT count(*) FROM ".DBPREFIX."category WHERE id = ${_GET['id']}";
	$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	if($rows == 0){	error("カテゴリID：${_GET['id']}は存在しません、LINE=".__LINE__); }
	$sql = "SELECT * FROM ".DBPREFIX."category WHERE id = ${_GET['id']}";
	$item = $db->fetch_array_assoc($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	foreach(array('ct_name', 'outline') as $key){	$$key = $db->escape_string($item[$key]); }

	$db->close();

	require(PATH_TEMPLATE."modify_category.html");
}
#----------------#
#  カテゴリ変更  #
#----------------#
function do_modify_category(){
	global $CNF;

	$_POST['id'] = intval($_POST['id']);
	if($_POST['id'] < 1){	error("IDが不正がです、LINE=".__LINE__); }
	// 文字数チェック
	if(mb_strlen($_POST['ct_name'], "utf-8") > 100){	error("カテゴリ名は100文字以内で入力して下さい、LINE=".__LINE__); }

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	foreach(array('ct_name', 'outline') as $key){	$_POST[$key] = $db->escape_string($_POST[$key]); }

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	foreach(array('url', 'tag_max') as $key){	$$key = $config_arr[$key]; }

	check_user_cookie($CNF['cookie_name'],$config_arr['pass']);

	$result = $db->transaction_begin();

	$sql = "SELECT count(*) FROM ".DBPREFIX."category WHERE id = ${_POST['id']}";
	$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	if($rows == 0){	error("カテゴリID：${_POST['id']}は存在しません、LINE=".__LINE__); }

	$sql = "UPDATE ".DBPREFIX."category SET";
	$sql .= " ct_name = '${_POST['ct_name']}',";
	$sql .= " outline = '${_POST['outline']}'";
	$sql .= " WHERE id = ${_POST['id']}";
	$result = $db->query($sql);

	$result = $db->transaction_commit();
	$db->close();

	$msg_title = "カテゴリ変更しました。";
	$msg_detail = "カテゴリ変更しました。";
	require(PATH_TEMPLATE."finish.html");
}
#------------------------#
#  カテゴリ削除画面表示  #
#------------------------#
function show_delete_category(){
	global $CNF;

	$_GET['id'] = intval($_GET['id']);
	if($_GET['id'] < 1){	error("IDが不正がです、LINE=".__LINE__); }

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	check_user_cookie($CNF['cookie_name'],$config_arr['pass']);

	foreach(array('title', 'url', 'tag_max') as $key){	$$key = $config_arr[$key]; }

	$sql = "SELECT count(*) FROM ".DBPREFIX."category WHERE id = ${_GET['id']}";
	$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	if($rows == 0){	error("カテゴリID：${_GET['id']}は存在しません、LINE=".__LINE__); }
	$sql = "SELECT * FROM ".DBPREFIX."category WHERE id = ${_GET['id']}";
	$item = $db->fetch_array_assoc($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	foreach(array('ct_name', 'outline') as $key){	$$key = $db->escape_string($item[$key]); }

	$db->close();

	require(PATH_TEMPLATE."delete_category.html");
}
#----------------#
#  カテゴリ削除  #
#----------------#
function do_delete_category(){
	global $CNF;

	$_POST['id'] = intval($_POST['id']);
	if($_POST['id'] < 1){	error("IDが不正がです、LINE=".__LINE__); }

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	foreach(array('url') as $key){	$$key = $config_arr[$key]; }

	check_user_cookie($CNF['cookie_name'],$config_arr['pass']);

	$result = $db->transaction_begin();

	$sql = "DELETE FROM ".DBPREFIX."category WHERE id = ${_POST['id']}";
	$result = $db->query($sql);

	$result = $db->transaction_commit();
	$db->close();

	$msg_title = "カテゴリ削除しました。";
	$msg_detail = "カテゴリ削除しました。";
	require(PATH_TEMPLATE."finish.html");
}
#----------------------------#
#  カテゴリ並び替え画面表示  #
#----------------------------#
function show_modify_order(){
	global $CNF;

	if(isset($_GET['ct_parent']) && $_GET['ct_parent'] != "" && !preg_match('/^[0-9]{6}$/', $_GET['ct_parent'])){
		error("親カテゴリが不正がです、LINE=".__LINE__);
	}
	$ct_parent = (isset($_GET['ct_parent']) && preg_match('/^[0-9]{6}$/', $_GET['ct_parent'])) ? $_GET['ct_parent'] : "";

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	check_user_cookie($CNF['cookie_name'],$config_arr['pass']);

	foreach(array('title', 'url') as $key){	$$key = $config_arr[$key]; }

	// カテゴリselect_box取得
	$ct_select_box = get_ct_select_box($db,"show",$ct_parent);

	// カテゴリ一覧取得
	$list_category = get_list_category($db,$ct_parent,$_GET['mode']);

	$db->close();
	require(PATH_TEMPLATE."modify_order.html");
}
#--------------------#
#  カテゴリ並び替え  #
#--------------------#
function do_modify_order(){
	global $CNF;

	$order_arr = array();
	$order_arr = $_POST['order'];

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	check_user_cookie($CNF['cookie_name'],$config_arr['pass']);

	foreach(array('url') as $key){	$$key = $config_arr[$key]; }

	$result = $db->transaction_begin();

	check_order_category($db,$order_arr);

	while(list($key, $value) = each($order_arr)){
		$sql = "UPDATE ".DBPREFIX."category SET";
		$sql .= " rank = ${value}";
		$sql .= " WHERE id = ${key}";
		$result = $db->query($sql);
	}

	$result = $db->transaction_commit();
	$db->close();

	$msg_title = "カテゴリ並び替えました。";
	$msg_detail = "カテゴリ並び替えました。";
	require(PATH_TEMPLATE."finish.html");
}
#--------------------------#
#  パスワード変更画面表示  #
#--------------------------#
function show_modify_pass(){
	global $CNF;

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	check_user_cookie($CNF['cookie_name'],$config_arr['pass']);

	foreach(array('title', 'url') as $key){	$$key = $config_arr[$key]; }

	$sql = "SELECT count(*) FROM ".DBPREFIX."config WHERE kw = 'pass'";
	$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	if($rows == 0){	error("パスワードが確認出来ませんでした、LINE=".__LINE__); }
	$sql = "SELECT id FROM ".DBPREFIX."config WHERE kw = 'pass'";
	$item = $db->fetch_array_assoc($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);

	$db->close();

	require(PATH_TEMPLATE."modify_pass.html");
}
#------------------#
#  パスワード変更  #
#------------------#
function do_modify_pass(){
	global $CNF;

	$_POST['id'] = intval($_POST['id']);
	if($_POST['id'] < 1){	error("IDが不正がです、LINE=".__LINE__); }
	if(!preg_match('/^[0-9a-z]{3,8}$/i', $_POST['pass'])){	error("パスワードは半角英数で3～8文字で設定して下さい、LINE=".__LINE__); }
	if(!preg_match('/^[0-9a-z]{3,8}$/i', $_POST['pass_again'])){	error("もう一度パスワードを半角英数で3～8文字で設定して下さい、LINE=".__LINE__); }
	if($_POST['pass'] != $_POST['pass_again']){	error("2つのパスワードが一致していません、LINE=".__LINE__); }
	$pass = sha1($_POST['pass']);

	require_once(PATH_LIB.DBSTR.".php");

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	check_user_cookie($CNF['cookie_name'],$config_arr['pass']);

	foreach(array('title', 'url') as $key){	$$key = $config_arr[$key]; }

	$result = $db->transaction_begin();

	$sql = "UPDATE ".DBPREFIX."config SET";
	$sql .= " value = '${pass}'";
	$sql .= " WHERE id = ${_POST['id']}";
	$result = $db->query($sql);

	$result = $db->transaction_commit();
	$db->close();

	// Cookie再セット
	if(isset($_COOKIE[$CNF['cookie_name']])){	setcookie($CNF['cookie_name']); }
	$pass_encrypted = sha1($pass);
	set_user_cookie($CNF['cookie_name'],$pass_encrypted,$CNF['secret_key']);

	$msg_title = "パスワード変更しました。";
	$msg_detail = "パスワード変更しました。<br><br><a href=\"".t2h($url.'?mode=login')."\">再度、ログインし直して下さい。</a>";
	require(PATH_TEMPLATE."finish.html");
}
#----------------#
#  環境設定変更  #
#----------------#
function do_env(){
	global $CNF;

	// 環境設定入力チェック
	check_input_env();

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	foreach(array('url') as $key){	$$key = $config_arr[$key]; }

	check_user_cookie($CNF['cookie_name'],$config_arr['pass']);

	$result = $db->transaction_begin();

	foreach(array('title', 'url', 'flag_html', 'url', 'pageview', 'faq_num', 'tag_num', 'page_control',
'order', 'show', 'click', 'tag_max', 'tag_len', 'show_ct', 'order_tag', 'flag_referer') as $key){
		$sql = "UPDATE ".DBPREFIX."config SET value = '".$db->escape_string($_POST[$key])."' WHERE kw = '${key}'";
		$result = $db->query($sql);
	}

	$result = $db->transaction_commit();

	$db->close();

	$msg_title = "環境設定変更しました。";
	$msg_detail = "環境設定変更しました。";
	require(PATH_TEMPLATE."finish.html");
}
#------------------------#
#  環境設定入力チェック  #
#------------------------#
function check_input_env(){
	global $CNF_detail;

	foreach(array('order', 'show', 'click', 'show_ct', 'order_tag', 'flag_referer') as $key){
		$_POST[$key] = intval($_POST[$key]);
	}
	if($_POST['title'] == ""){
		error("ホームのタイトルを入力して下さい。 LINE=".__LINE__);
	}elseif($_POST['url'] == "http://" || $_POST['url'] == "https://" || $_POST['url'] == ""){
		error("ホームのURLを入力して下さい。 LINE=".__LINE__);
	}elseif($_POST['order'] > 1){
		error("FAQの表示順序が不正です。 LINE=".__LINE__);
	}elseif($_POST['show'] > 1){
		error("FAQ表示方法が不正です。 LINE=".__LINE__);
	}elseif($_POST['click'] > 1){
		error("各FAQリンクをクリックした時の表示方法が不正です。 LINE=".__LINE__);
	}elseif($_POST['show_ct'] > 1){
		error("カテゴリデータの表示方法が不正です。 LINE=".__LINE__);
	}elseif($_POST['order_tag'] > 1){
		error("タグ(キーワード)の表示順序が不正です。 LINE=".__LINE__);
	}elseif($_POST['flag_referer'] > 1){
		error("検索する時にリファラチェックするかどうかが不正です。 LINE=".__LINE__);
	}
	foreach(array('pageview', 'faq_num', 'tag_num', 'page_control', 'tag_max', 'tag_len') as $key){
		$_POST[$key] = intval($_POST[$key]);
		if(!preg_match('/^[0-9]+$/', $_POST[$key]) || $_POST[$key] == 0){
			error(t2h($CNF_detail[$key])."は1以上の整数で入力して下さい。 LINE=".__LINE__);
		}
	}
	foreach($CNF_detail as $key => $value){
		if(mb_strlen($_POST[$key], "utf-8") > 255){
			error(t2h($value)."は255文字以内で指定して下さい。 LINE=".__LINE__);
		}
	}
}
#--------------------------------#
#  カテゴリ並び替え入力チェック  #
#--------------------------------#
function check_order_category(&$db,&$order_arr){

	// IDチェック
	foreach($order_arr as $key => $value){
		if($key != intval($key)){	error("IDが不正がです、LINE=".__LINE__); }
		$sql = "SELECT count(*) FROM ".DBPREFIX."category WHERE $key = ${key}";
		$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		if($rows == 0){	error("IDに対応するカテゴリが存在しません、LINE=".__LINE__); }
	}
	// orderチェック
	$count_arr = count($order_arr);
	asort($order_arr);
	$cnt = 0;
	foreach($order_arr as $key => $value){
		$cnt++;
		if($cnt != $value){
			if($count_arr == 1){
				error("表示順は1以外入力できません、LINE=".__LINE__);
			}else{
				error("表示順は1から${count_arr}の連番で入力して下さい、LINE=".__LINE__);
			}
		}
	}
	ksort($order_arr);
}
#--------------------#
#  カテゴリ一覧取得  #
#--------------------#
function get_list_category(&$db,$parent,$mode=""){
	global $CNF;

	$str = "";
	if(empty($parent)){
		$sql = "SELECT count(*) FROM ".DBPREFIX."category WHERE ct_cd like '%0000' ORDER BY ct_cd";
	}else{
		$str2_4 = substr($parent, 2, 4);
		$str4_2 = substr($parent, 4, 2);
		if(intval($str2_4) == 0){
			$ct_target = substr($parent, 0, 2)."%00";
			$ct_child = "00";
		}elseif(intval($str4_2) == 0){
			$ct_target = substr($parent, 0, 4)."%";
			$ct_child = "";
		}else{
			$ct_target = $parent;
		}
		$sql = "SELECT count(*) FROM ".DBPREFIX."category WHERE ct_cd like '${ct_target}' ORDER BY ct_cd";
	}
	$rows_all = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	$sql = str_replace("count(*)", "*", $sql);
	$items = $db->get_rows($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	$cnt = 0;
	foreach($items as $item){
		$cnt++;
		$bgcolor = ($cnt % 2) == 1 ? "#FFFFFF" : "#F5F5F5";
		$str2_4 = substr($item['ct_cd'], 2, 4);
		$str4_2 = substr($item['ct_cd'], 4, 2);
		if(intval($str2_4) == 0){
			$ct_target = substr($item['ct_cd'], 0, 2)."%00";
		}elseif(intval($str4_2) == 0){
			$ct_target = substr($item['ct_cd'], 0, 4)."%";
		}else{
			$ct_target = "";
		}
		if($mode != "modify_order"){
			if(empty($ct_target)){
				$rows = 0;
			}else{
				$sql = "SELECT count(*) FROM ".DBPREFIX."category WHERE ct_cd like '${ct_target}' AND ct_cd <> '${item['ct_cd']}'";
				$rows = intval($db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__));
				if($rows > 0){
					$rows = "<a href=\"${CNF['admin']}?mode=category&ct_parent=${item['ct_cd']}\">${rows}</a>";
				}
			}
		}else{
			$order = $item['ct_cd'] == $parent ? "" : "<input type=\"text\" name=\"order[${item['id']}]\" size=\"1\" class=\"input_bgcolor\" value=\"${item['rank']}\">";
		}
		$ct_name = $item['ct_name'];
		if(!empty($parent) && $parent != $item['ct_cd']){
			if($cnt >= 1 && $cnt < $rows_all){
				$ct_name = "├&nbsp;" . $ct_name;
			}elseif($cnt == $rows_all){
				$ct_name = "└&nbsp;" . $ct_name;
			}
		}
		if(empty($str)){
			if($mode != "modify_order"){
				$str .= <<<EOM
<table border="0" width="100%" cellspacing="1" cellpadding="5">
<tr>
<td bgcolor="#F0F0F0" width="30" align="center" nowrap><b>ID</b></td>
<td bgcolor="#F0F0F0" width="50" align="center" nowrap><b>カテゴリID</b></td>
<td bgcolor="#F0F0F0" align="center" nowrap><b>カテゴリ名</b></td>
<td bgcolor="#F0F0F0" width="70" align="center" nowrap><b>サブカテゴリ</b></td>
<td bgcolor="#F0F0F0" width="40" align="center" nowrap><b>変更</b></td>
<td bgcolor="#F0F0F0" width="40" align="center" nowrap><b>削除</b></td>
</tr>
EOM;
			}else{
				$str .= <<<EOM
<table border="0" width="100%" cellspacing="1" cellpadding="5">
<tr>
<td bgcolor="#F0F0F0" width="30" align="center" nowrap><b>ID</b></td>
<td bgcolor="#F0F0F0" width="50" align="center" nowrap><b>カテゴリID</b></td>
<td bgcolor="#F0F0F0" align="center" nowrap><b>カテゴリ名</b></td>
<td bgcolor="#F0F0F0" width="60" align="center" nowrap><b>表示順</b></td>
</tr>
EOM;
			}
		}
		$item['ct_name'] = t2h($item['ct_name']);
		if($mode != "modify_order"){
			$str .= <<<EOM
<tr>
<td bgcolor="${bgcolor}" width="30" align="center" nowrap>${item['id']}</td>
<td bgcolor="${bgcolor}" width="50" align="center" nowrap>${item['ct_cd']}</td>
<td bgcolor="${bgcolor}" align="left" nowrap>${ct_name}</td>
<td bgcolor="${bgcolor}" width="70" align="center" nowrap>${rows}</td>
<td bgcolor="${bgcolor}" width="40" align="center"><a href="${CNF['admin']}?mode=modify_category&id=${item['id']}">変更</a></td>
<td bgcolor="${bgcolor}" width="40" align="center"><a href="${CNF['admin']}?mode=delete_category&id=${item['id']}">削除</a></td>
</tr>
EOM;
		}else{
			$str .= <<<EOM
<tr>
<td bgcolor="${bgcolor}" width="30" align="center" nowrap>${item['id']}</td>
<td bgcolor="${bgcolor}" width="50" align="center" nowrap>${item['ct_cd']}</td>
<td bgcolor="${bgcolor}" align="left" nowrap>${ct_name}</td>
<td bgcolor="${bgcolor}" width="60" align="center" nowrap>${order}</td>
</tr>
EOM;
		}
	}
	if(!empty($str)){
		$str .= <<<EOM
</table>\n
EOM;
	}

	return $str;
}
#----------------#
#  FAQ一覧取得   #
#----------------#
function get_list_faqs_for_admin(&$db,&$items,$parent){
	global $CNF;

	$str = "";
	$cnt = 0;
	foreach($items as $item){
		$cnt++;
		$bgcolor = ($cnt % 2) == 1 ? "#FFFFFF" : "#F5F5F5";
		$str2_4 = substr($item['ct_cd'], 2, 4);
		$str4_2 = substr($item['ct_cd'], 4, 2);
		if(intval($str2_4) == 0){
			$ct_target = substr($item['ct_cd'], 0, 2)."%00";
		}elseif(intval($str4_2) == 0){
			$ct_target = substr($item['ct_cd'], 0, 4)."%";
		}else{
			$ct_target = "";
		}
		if(empty($ct_target)){
			$rows = 0;
			$rows_str = 0;
		}else{
			$sql = "SELECT count(*) FROM ".DBPREFIX."master WHERE ct_cd like '${ct_target}' AND ct_cd <> '${item['ct_cd']}'";
			$rows = intval($db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__));
			if($rows > 0){
				$rows_str = "<a href=\"${CNF['admin']}?mode=category&ct_parent=${item['ct_cd']}\">${rows}</a>";
			}else{
				$rows_str = 0;
			}
		}
		$ct_name = (isset($item['ct_name']) && $item['ct_name'] != "") ? $item['ct_name'] : "";
		$status = intval($item['status']) == 1 ? "○" : "×";
		if(!empty($parent)){
			if($cnt > 1 && $cnt < $rows){
				$ct_name = "├&nbsp;" . $ct_name;
			}elseif($cnt == $rows){
				$ct_name = "└&nbsp;" . $ct_name;
			}
		}
		if(empty($str)){
			$str .= <<<EOM
<table border="0" width="100%" cellspacing="1" cellpadding="5">
<tr>
<td bgcolor="#F0F0F0" width="30" align="center" nowrap><b>ID</b></td>
<td bgcolor="#F0F0F0" width="50" align="center" nowrap><b>カテゴリID</b></td>
<td bgcolor="#F0F0F0" align="center" nowrap><b>質問</b></td>
<td bgcolor="#F0F0F0" width="40" align="center" nowrap><b>掲載</b></td>
<td bgcolor="#F0F0F0" width="70" align="center" nowrap><b>サブカテゴリ</b></td>
<td bgcolor="#F0F0F0" width="40" align="center" nowrap><b>変更</b></td>
<td bgcolor="#F0F0F0" width="40" align="center" nowrap><b>削除</b></td>
</tr>
EOM;
		}
		$str .= <<<EOM
<tr>
<td bgcolor="${bgcolor}" width="30" align="center" nowrap>${item['id']}</td>
<td bgcolor="${bgcolor}" width="50" align="center" nowrap>${item['ct_cd']}</td>
<td bgcolor="${bgcolor}" align="left">${item['question']}</td>
<td bgcolor="${bgcolor}" width="40" align="center" nowrap>${status}</td>
<td bgcolor="${bgcolor}" width="70" align="center" nowrap>${rows_str}</td>
<td bgcolor="${bgcolor}" width="40" align="center"><a href="${CNF['admin']}?mode=modify&id=${item['id']}">変更</a></td>
<td bgcolor="${bgcolor}" width="40" align="center"><a href="${CNF['admin']}?mode=delete&id=${item['id']}">削除</a></td>
</tr>
EOM;
	}
	if(!empty($str)){
		$str .= <<<EOM
</table>\n
EOM;
	}

	return $str;
}
#--------------------------#
#  カテゴリselect_box取得  #
#--------------------------#
function get_ct_select_box(&$db,$mode="show",$ct_cd=""){
	global $CNF,$config_arr;

	if($mode == "show"){
		$str = "\n<select name=\"ct_parent\" size=\"1\">\n<option value=\"\" selected>--選択して下さい▼--\n";
	}else{
		$str = "\n<select name=\"ct_parent\" size=\"1\">\n<option value=\"\" selected>--指定しない--\n";
	}
	$sql = "SELECT count(*) FROM ".DBPREFIX."category";
	$rows_all = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	if($mode == "show" && $rows_all == 0){
		foreach(array('title', 'url') as $key){	$$key = $config_arr[$key]; }
		$msg_title = "カテゴリがありません。";
		$msg_detail = "カテゴリがありません。カテゴリを追加して下さい。";
		require(PATH_TEMPLATE."finish.html");
		exit;
	}
	if($rows_all > 0){
	$sql = "SELECT ct_cd,ct_name FROM ".DBPREFIX."category ORDER BY ct_cd";
	$items = $db->get_rows($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	foreach($items as $item){
		$str2_4 = substr($item['ct_cd'], 2, 4);
		$str4_2 = substr($item['ct_cd'], 4, 2);
		if(intval($str2_4) == 0){
			if($ct_cd == $item['ct_cd']){
				$str .= "<option value=\"${item['ct_cd']}\" selected>${item['ct_name']}\n";
			}else{
				$str .= "<option value=\"${item['ct_cd']}\">${item['ct_name']}\n";
			}
			$ct_parent_name1 = $item['ct_name'];
		}elseif(intval($str4_2) == 0){
			if($ct_cd == $item['ct_cd']){
				$str .= "<option value=\"${item['ct_cd']}\" selected>${ct_parent_name1}：${item['ct_name']}\n";
			}else{
				$str .= "<option value=\"${item['ct_cd']}\">${ct_parent_name1}：${item['ct_name']}\n";
			}
			$ct_parent_name2 = $item['ct_name'];
		}elseif($mode != "parent"){
			if($ct_cd == $item['ct_cd']){
				$str .= "<option value=\"${item['ct_cd']}\" selected>${ct_parent_name1}：${ct_parent_name2}：${item['ct_name']}\n";
			}else{
				$str .= "<option value=\"${item['ct_cd']}\">${ct_parent_name1}：${ct_parent_name2}：${item['ct_name']}\n";
			}
		}
	}
	}
	$str .= "</select>";

	return $str;
}
#----------------#
#  カテゴリ追加  #
#----------------#
function do_add_category(){
	global $CNF;

	if(isset($_POST['ct_parent']) && $_POST['ct_parent'] != "" && !preg_match('/^[0-9]{6}$/', $_POST['ct_parent'])){
		error("親カテゴリが不正がです、LINE=".__LINE__);
	}

	// 親カテゴリチェック
	$str0_2 = substr($_POST['ct_parent'], 0, 2);
	$str2_2 = substr($_POST['ct_parent'], 2, 2);
	$str4_2 = substr($_POST['ct_parent'], 4, 2);
	$str0_4 = substr($_POST['ct_parent'], 0, 4);
	$str2_4 = substr($_POST['ct_parent'], 2, 4);

	if($_POST['ct_parent'] == ""){
		$ct_child = 1;
		$ct_target = "";
		$ct_upline = "";
		$ct_key = "";
	}elseif(intval($str2_4) == 0){
		$ct_child = 2;
		$ct_target = $str0_2."%00";
		$ct_upline = $str0_2."0000";
		$ct_key = $str0_2;
	}elseif(intval($str4_2) == 0){
		$ct_child = 3;
		$ct_target = $str0_4."%";
		$ct_upline = $str0_4."00";
		$ct_key = $str0_4;
	}else{
		error("親カテゴリが不正がです、LINE=".__LINE__);
	}

	// 文字数チェック
	if(mb_strlen($_POST['ct_name'], "utf-8") > 100){	error("カテゴリ名は100文字以内で入力して下さい、LINE=".__LINE__); }

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	foreach(array('url') as $key){	$$key = $config_arr[$key]; }

	check_user_cookie($CNF['cookie_name'],$config_arr['pass']);

	$result = $db->transaction_begin();

	// 追加するカテゴリコード取得
	$ct_arr = get_next_ct_cd($db,$ct_child,$ct_target,$ct_upline,$ct_key);

	foreach(array('ct_name', 'outline') as $key){	$_POST[$key] = $db->escape_string($_POST[$key]); }

	$line = "NULL,'${ct_arr['ct_cd']}','${_POST['ct_name']}','${_POST['outline']}',${ct_arr['rank']}";
	$sql = "INSERT INTO ".DBPREFIX."category VALUES ($line)";

	$result = $db->query($sql);

	$result = $db->transaction_commit();
	$db->close();

	$msg_title = "カテゴリ追加しました。";
	$msg_detail = "カテゴリ追加しました。";
	require(PATH_TEMPLATE."finish.html");
}
#------------------------------#
#  追加するカテゴリコード取得  #
#------------------------------#
function get_next_ct_cd(&$db,&$ct_child,&$ct_target,$ct_upline="",$ct_key){

	$arr = array();
	if($ct_child == 1){
		$sql = "SELECT count(*) FROM ".DBPREFIX."category WHERE ct_name = '${_POST['ct_name']}' and ct_cd like '%0000'";
		$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		if($rows >= 1){	error("指定したカテゴリ名は既に存在しています、LINE=".__LINE__); }
		$sql = "SELECT count(*) FROM ".DBPREFIX."category";
		$item = $db->fetch_array_assoc($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		if($item['count(*)'] == 0){
			$arr['ct_cd'] = "010000";
			$arr['rank'] = 1;
		}else{
			$sql = "SELECT ct_cd,rank FROM ".DBPREFIX."category ORDER BY ct_cd DESC limit 0, 1";
			$item = $db->fetch_array_assoc($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
			$ct_cd_tmp = intval(substr($item['ct_cd'], 0, 2));
			if($ct_cd_tmp >= 99){	error("作れるカテゴリは99個までです、LINE=".__LINE__); }
			$ct_cd_tmp++;
			$arr['ct_cd'] = sprintf("%02d", $ct_cd_tmp)."0000";
			$item['rank']++;
			$arr['rank'] = $item['rank'];
		}
	}elseif($ct_child == 2){
		$sql = "SELECT count(*) FROM ".DBPREFIX."category WHERE ct_cd = '${_POST['ct_parent']}'";
		$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		if($rows == 0){	error("親カテゴリ：".t2h($_POST['ct_parent'])."の登録データは存在しません、LINE=".__LINE__); }
		$sql = "SELECT count(*) FROM ".DBPREFIX."category WHERE ct_name = '".$db->escape_string($_POST['ct_name'])."' and ct_cd like '${ct_key}%00'";
		$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		if($rows > 0){	error("指定したカテゴリ名は既に存在しています、LINE=".__LINE__); }
		$sql = "SELECT count(*) FROM ".DBPREFIX."category WHERE ct_cd like '${ct_target}' AND ct_cd <> '${ct_upline}'";
		$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		if($rows == 0){
			$arr['ct_cd'] = $ct_key . "0100";
			$arr['rank'] = 1;
			return $arr;
		}
		$sql = "SELECT ct_cd,rank FROM ".DBPREFIX."category WHERE ct_cd like '${ct_target}' AND ct_cd <> '${ct_upline}' ORDER BY ct_cd DESC limit 0, 1";
		$item = $db->fetch_array_assoc($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		$ct_cd_tmp = intval(substr($item['ct_cd'], 0, 4));
		$ct_cd_tmp2_2 = substr($ct_cd_tmp, 2, 2);
		if(intval($ct_cd_tmp2_2) >= 99){	error("作れるサブカテゴリは99個までです、LINE=".__LINE__); }
		$ct_cd_tmp++;
		$arr['ct_cd'] = sprintf("%04d", $ct_cd_tmp)."00";
		$item['rank']++;
		$arr['rank'] = $item['rank'];
	}else{
		$sql = "SELECT count(*) FROM ".DBPREFIX."category WHERE ct_cd = '${_POST['ct_parent']}'";
		$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		if($rows == 0){	error("親カテゴリ：".t2h($_POST['ct_parent'])."の登録データは存在しません、LINE=".__LINE__); }
		$sql = "SELECT count(*) FROM ".DBPREFIX."category WHERE ct_name = '".$db->escape_string($_POST['ct_name'])."' and ct_cd like '${ct_key}%'";
		$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		if($rows > 0){	error("指定したカテゴリ名は既に存在しています、LINE=".__LINE__); }
		$sql = "SELECT count(*) FROM ".DBPREFIX."category WHERE ct_cd like '${ct_target}' AND ct_cd <> '${ct_upline}'";
		$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		if($rows == 0){
			$arr['ct_cd'] = $ct_key . "01";
			$arr['rank'] = 1;
			return $arr;
		}
		$sql = "SELECT ct_cd,rank FROM ".DBPREFIX."category WHERE ct_cd like '${ct_target}' AND ct_cd <> '${ct_upline}' ORDER BY ct_cd DESC limit 0, 1";
		$item = $db->fetch_array_assoc($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		$ct_cd_tmp = intval($item['ct_cd']);
		$ct_cd_tmp4_2 = substr($ct_cd_tmp, 4, 2);
		if(intval($ct_cd_tmp4_2) >= 99){	error("作れるサブカテゴリは99個までです、LINE=".__LINE__); }
		$ct_cd_tmp++;
		$arr['ct_cd'] = sprintf("%06d", $ct_cd_tmp);
		$item['rank']++;
		$arr['rank'] = $item['rank'];
	}

	return $arr;
}
#-------------------#
#  FAQ登録画面表示  #
#-------------------#
function entry(){
	global $CNF,$config_arr;

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	check_user_cookie($CNF['cookie_name'],$config_arr['pass']);

	foreach(array('title', 'url', 'tag_max') as $key){	$$key = $config_arr[$key]; }

	$flag_html_str = intval($config_arr['flag_html']) > 0 ? "可" : "不可";

	// カテゴリselect_box取得
	$ct_select_box = get_ct_select_box($db,"show","");

	$db->close();

	require(PATH_TEMPLATE."entry.html");
}
#--------------#
#  プレビュー  #
#--------------#
function preview($mode=""){
	global $CNF,$ct_name;

	// 必須項目チェック
	if(trim($_POST['question']) == ""){	error("質問を入力して下さい、LINE=".__LINE__); }
	if(trim($_POST['answer']) == ""){	error("答えを入力して下さい、LINE=".__LINE__); }
	if(!preg_match('/^[0-9]{6}$/', $_POST['ct_parent'])){	error("カテゴリを選択して下さい、LINE=".__LINE__); }
	// 文字数チェック
	if(mb_strlen($_POST['question'], "utf-8") > 100){	error("質問は100文字以内で入力して下さい、LINE=".__LINE__); }

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	check_user_cookie($CNF['cookie_name'],$config_arr['pass']);

	// 受信データ整形（プレビュー表示用）
	$preview_arr = array();
	foreach(array('question', 'answer', 'tag') as $key){
		//$_POST[$key] = str_replace("<>", "&lt;&gt;", $_POST[$key]);
		$value = isset($_POST[$key]) ? $_POST[$key] : "";
		$_POST[$key] = trim($_POST[$key]);
		$value = trim($value);
		if(get_magic_quotes_gpc()){
			$_POST[$key] = stripslashes($_POST[$key]);
			$value = stripslashes($value);
		}
		if($key == "answer"){
			if($config_arr['flag_html'] == 1){
				$value = preg_replace('/\0/', '', $value);
				$value = preg_replace('/(\r\n|\r|\n)/', '<br>', $value);
				$_POST[$key] = str_replace("&amp;", "&amp;amp;", $_POST[$key]);
				$_POST[$key] = str_replace("&lt;", "&amp;lt;", $_POST[$key]);
				$_POST[$key] = str_replace("&gt;", "&amp;gt;", $_POST[$key]);
			}else{
				$_POST[$key] = strip_tags($_POST[$key]);
				$value = strip_tags($value);
				$value = t2h($value);
			}
		}elseif($key == "question"){
			$_POST[$key] = strip_tags($_POST[$key]);
			$value = strip_tags($value);
		}elseif($key == "tag"){
			if($value != ""){
				$_POST[$key] = strip_tags($_POST[$key]);
				$value = strip_tags($value);
				$_POST[$key] = mb_ereg_replace("(\s|　)+", " ", $_POST[$key]);
				$value = mb_ereg_replace("(\s|　)+", " ", $value);
			}
		}
		$value = empty($value) ? " " : $value;
		$preview_arr[$key] = $value;
	}
	if(intval($_POST['flag_pub']) < 1){
		$status = "掲載しない（下書き、又は掲載はしたくない時にチェック）";
		$checked_pub_str1 = "";
		$checked_pub_str0 = "checked";
	}else{
		$status = "掲載する";
		$checked_pub_str1 = "checked";
		$checked_pub_str0 = "";
	}
	
	foreach(array('title', 'url', 'tag_max') as $key){	$$key = $config_arr[$key]; }

	$flag_html_str = intval($config_arr['flag_html']) > 0 ? "可" : "不可";

	// タグ（キーワード）チェック
	$tag_arr = check_tags($config_arr['tag_max'],$config_arr['tag_len']);

	// カテゴリ名取得
	$ct_navi = get_ct_navi($db,$_POST['ct_parent']);

	// カテゴリselect_box取得
	$ct_select_box = get_ct_select_box($db,"",$_POST['ct_parent']);

	$db->close();

	if($mode == "modify"){
		require(PATH_TEMPLATE."modify_preview.html");
	}else{
		require(PATH_TEMPLATE."preview.html");
	}
}
#------------------#
#  カテゴリ名取得  #
#------------------#
function get_ct_navi(&$db,$ct_cd){

	$str = "";
	if(!preg_match('/^[0-9]{6}$/', $ct_cd)){	return $str; }
	$str0_2 = substr($ct_cd, 0, 2);
	$str2_2 = substr($ct_cd, 2, 2);
	$str4_2 = substr($ct_cd, 4, 2);
	$str0_4 = substr($ct_cd, 0, 4);
	$str2_4 = substr($ct_cd, 2, 4);
	if(intval($str2_4) == 0){
		$arr = array($ct_cd);
	}elseif(intval($str4_2) == 0){
		$arr = array($str0_2 . "0000", $ct_cd);
	}else{
		$arr = array($str0_2 . "0000", $str0_4 . "00" ,$ct_cd);
	}
	foreach($arr as $key){
		if(!empty($str)){	$str .= "："; }
		$sql = "SELECT ct_name FROM ".DBPREFIX."category WHERE ct_cd = '${key}'";
		$item = $db->fetch_array_assoc($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		if(!empty($item['ct_name'])){	$str .= $item['ct_name']; }
	}

	return $str;
}
#-----------#
#  FAQ登録  #
#-----------#
function do_entry(){
	global $CNF,$timezone;

	// 必須項目チェック
	if(trim($_POST['question']) == ""){	error("質問を入力して下さい、LINE=".__LINE__); }
	if(trim($_POST['answer']) == ""){	error("答えを入力して下さい、LINE=".__LINE__); }
	if(!preg_match('/^[0-9]{6}$/', $_POST['ct_parent'])){	error("カテゴリを選択して下さい、LINE=".__LINE__); }
	// 文字数チェック
	if(mb_strlen($_POST['question'], "utf-8") > 100){	error("質問は100文字以内で入力して下さい、LINE=".__LINE__); }

	$YmdHi = gmdate("YmdHi",time()+$timezone*60*60);

	$_POST['flag_pub'] = intval($_POST['flag_pub']) > 0 ? 1 : 0;

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	check_user_cookie($CNF['cookie_name'],$config_arr['pass']);

	foreach(array('url') as $key){	$$key = $config_arr[$key]; }

	if($config_arr['flag_html'] == 0){
		foreach(array('question', 'answer') as $key){	$_POST[$key] = t2h($_POST[$key]); }
	}else{
		$_POST['question'] = t2h($_POST['question']);
	}

	foreach(array('question', 'answer') as $key){	$_POST[$key] = $db->escape_string($_POST[$key]); }

	// 重複登録チェック
	$sql = "SELECT count(*) FROM ".DBPREFIX."master WHERE ct_cd = '${_POST['ct_parent']}'";
	$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	if($rows > 0){
		$sql = "SELECT question FROM ".DBPREFIX."master WHERE ct_cd = '${_POST['ct_parent']}'";
		$items = $db->get_rows($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		foreach($items as $item){
			if($item['question'] == $_POST['question']){	error("既にその質問は登録されています、LINE=".__LINE__);	}
		}
	}

	// タグ（キーワード）チェック
	$tag_arr = check_tags($config_arr['tag_max'],$config_arr['tag_len']);

	$status = 1;
	$result = $db->transaction_begin();

	$line = "NULL,'${_POST['ct_parent']}','${_POST['question']}','${_POST['answer']}',${YmdHi},${YmdHi},${_POST['flag_pub']}";
	$sql = "INSERT INTO ".DBPREFIX."master VALUES ($line)";
	$result = $db->query($sql);
	if(!$result){	$status = 0;	}
	$inserted_id = $db->insert_id($_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	if($_POST['tag'] != "" && $status){
		if(is_array($tag_arr)){	reset($tag_arr); }
		while(list(,$value) = each($tag_arr)){
			if(empty($value)){	continue; }
			$value = $db->escape_string($value);
			$line  = "NULL,${inserted_id},'${value}',1,${_POST['flag_pub']}";
			$sql = "INSERT INTO ".DBPREFIX."tags VALUES ($line)";
			$result = $db->query($sql);
			if(!$result){	$status = 0;	}
		}
	}
	if(!$status){
		$result = $db->transaction_rollback();
		error("FAQ登録中にエラーが発生しました、LINE=".__LINE__);
	}else{
		$result = $db->transaction_commit();
	}
	$db->close();

	$msg_title = "FAQ登録しました。";
	$msg_detail = "FAQ登録しました。";
	require(PATH_TEMPLATE."finish.html");
}
#-------------------#
#  FAQ変更画面表示  #
#-------------------#
function show_modify(){
	global $CNF;

	if(intval($_GET['id']) < 1){	error("IDが不正です、LINE=".__LINE__); }

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	$flag_html_str = intval($config_arr['flag_html']) > 0 ? "可" : "不可";

	check_user_cookie($CNF['cookie_name'],$config_arr['pass']);

	$sql = "SELECT count(*) FROM ".DBPREFIX."master WHERE id = '${_GET['id']}'";
	$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	if($rows == 0){	error("ID：${_GET['id']}の登録データは存在しません、LINE=".__LINE__); }
	$sql = "SELECT * FROM ".DBPREFIX."master WHERE id = '${_GET['id']}'";
	$item = $db->fetch_array_assoc($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);

	if(intval($item['status']) < 1){
		$checked_pub_str1 = "";
		$checked_pub_str0 = "checked";
	}else{
		$checked_pub_str1 = "checked";
		$checked_pub_str0 = "";
	}

	// タグ -> テキスト変換
	foreach(array('question', 'answer') as $key){
		if(get_magic_quotes_gpc()){	$item[$key] = stripslashes($item[$key]); }
		if($config_arr['flag_html'] == 1){
			if($key == "question"){
				$item[$key] = h2t($item[$key]);
			}else{
				$item[$key] = str_replace("&#44;", ",", $item[$key]);
				$item[$key] = ereg_replace("<br>", "\n", $item[$key]);
			}
		}else{
			$item[$key] = h2t($item[$key]);
		}
	}
	$item['question'] = h2t($item['question']);
	// タグ（キーワード）セットアップ
	$sql = "SELECT count(*) FROM ".DBPREFIX."tags WHERE id = ${_GET['id']}";
	$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	$tags = "";
	if($rows > 0){
		$sql = "SELECT no,tag FROM ".DBPREFIX."tags WHERE id = ${_GET['id']}";
		$items = $db->get_rows($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		foreach($items as $item_tmp){	$tags .= $item_tmp['tag'] . " "; }
		$tags = trim($tags);
		$tags = str_replace("&#44;", ",", $tags);
		unset($item_tmp);
	}

	foreach(array('title', 'url', 'tag_max') as $key){	$$key = $config_arr[$key]; }

	// カテゴリselect_box取得
	$ct_select_box = get_ct_select_box($db,"",$item['ct_cd']);

	$db->close();

	require(PATH_TEMPLATE."modify.html");
}
#-------------------#
#  FAQ削除画面表示  #
#-------------------#
function show_delete(){
	global $CNF;

	$_GET['id'] = intval($_GET['id']);
	if($_GET['id'] < 1){	error("IDが不正です、LINE=".__LINE__); }

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	$sql = "SELECT count(*) FROM ".DBPREFIX."master WHERE id = '${_GET['id']}'";
	$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	if($rows == 0){	error("ID：${_GET['id']}の登録データは存在しません、LINE=".__LINE__); }
	$sql = "SELECT * FROM ".DBPREFIX."master WHERE id = '${_GET['id']}'";
	$item = $db->fetch_array_assoc($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);

	// タグ（キーワード）セットアップ
	$sql = "SELECT count(*) FROM ".DBPREFIX."tags WHERE id = ${_GET['id']}";
	$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	$tags = "";
	if($rows > 0){
		$sql = "SELECT no,tag FROM ".DBPREFIX."tags WHERE id = ${_GET['id']}";
		$items = $db->get_rows($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		foreach($items as $item_tmp){	$tags .= $item_tmp['tag'] . " "; }
		$tags = trim($tags);
		$tags = str_replace("&#44;", ",", $tags);
		unset($item_tmp);
	}

	$status = intval($item['flag_pub']) > 0 ? "掲載する" : "掲載しない（下書き、又は掲載はしたくない時にチェック）";

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	check_user_cookie($CNF['cookie_name'],$config_arr['pass']);

	foreach(array('title', 'url', 'tag_max') as $key){	$$key = $config_arr[$key]; }

	// カテゴリ名取得
	$ct_navi = get_ct_navi($db,$item['ct_cd']);

	// カテゴリselect_box取得
	$ct_select_box = get_ct_select_box($db,"",$item['ct_cd']);

	$db->close();

	require(PATH_TEMPLATE."delete.html");
}
#-----------#
#  FAQ削除  #
#-----------#
function do_delete(){
	global $CNF;

	$_POST['id'] = intval($_POST['id']);
	if($_POST['id'] < 1){	error("IDが不正です、LINE=".__LINE__); }

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	check_user_cookie($CNF['cookie_name'],$config_arr['pass']);

	// 登録データ存在チェック
	$sql = "SELECT count(*) FROM ".DBPREFIX."master WHERE id = ${_POST['id']}";
	$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	if($rows == 0){	error("ID：${_POST['id']}の登録データは存在しません、LINE=".__LINE__); }

	$status = 1;
	$result = $db->transaction_begin();

	$sql = "DELETE FROM ".DBPREFIX."master WHERE id = ${_POST['id']}";
	$result = $db->query($sql);
	if(!$result){	$status = 0;	}
	$sql = "DELETE FROM ".DBPREFIX."tags WHERE id = ${_POST['id']}";
	$result = $db->query($sql);
	if(!$result){	$status = 0;	}

	if(!$status){
		$result = $db->transaction_rollback();
		error("FAQ削除中にエラーが発生しました、LINE=".__LINE__);
	}else{
		$result = $db->transaction_commit();
	}
	$db->close();

	$msg_title = "FAQ削除しました。";
	$msg_detail = "FAQ削除しました。";
	require(PATH_TEMPLATE."finish.html");
}
#-----------#
#  FAQ変更  #
#-----------#
function do_modify(){
	global $CNF,$timezone;

	$_POST['id'] = intval($_POST['id']);
	if($_POST['id'] < 1){	error("IDが不正です、LINE=".__LINE__); }

	// 必須項目チェック
	if(trim($_POST['question']) == ""){	error("質問を入力して下さい、LINE=".__LINE__); }
	if(trim($_POST['answer']) == ""){	error("答えを入力して下さい、LINE=".__LINE__); }
	if(!preg_match('/^[0-9]{6}$/', $_POST['ct_parent'])){	error("カテゴリを選択して下さい、LINE=".__LINE__); }
	// 文字数チェック
	if(mb_strlen($_POST['question'], "utf-8") > 100){	error("質問は100文字以内で入力して下さい、LINE=".__LINE__); }

	$lastmodify = gmdate("YmdHi",time()+$timezone*60*60);

	$_POST['flag_pub'] = intval($_POST['flag_pub']) > 0 ? 1 : 0;

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	foreach(array('url') as $key){	$$key = $config_arr[$key]; }

	check_user_cookie($CNF['cookie_name'],$config_arr['pass']);

	if($config_arr['flag_html'] == 0){
		foreach(array('question', 'answer') as $key){	$_POST[$key] = t2h($_POST[$key]); }
	}else{
		$_POST['question'] = t2h($_POST['question']);
	}

	// 登録データ存在チェック
	$sql = "SELECT count(*) FROM ".DBPREFIX."master WHERE id = ${_POST['id']}";
	$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	if($rows == 0){	error("ID：${_POST['id']}の登録データは存在しません、LINE=".__LINE__); }

	// タグ（キーワード）チェック
	$tag_arr = check_tags($config_arr['tag_max'],$config_arr['tag_len']);

	$status = 1;
	$result = $db->transaction_begin();

	$sql = "UPDATE ".DBPREFIX."master SET ";
	$sql .= "ct_cd ='".$db->escape_string($_POST['ct_parent'])."', ";
	foreach(array('question', 'answer') as $key){
		$sql .= "${key} ='".$db->escape_string($_POST[$key])."', ";
	}
	$sql .= "lastmodify = ${lastmodify},";
	$sql .= "status = ${_POST['flag_pub']}";
	$sql .= " WHERE id=${_POST['id']}";
	$result = $db->query($sql);
	if(!$result){	$status = 0;	}
	if($_POST['tag'] != "" && $status){
		$tag_old_arr = array();
		$sql = "SELECT count(*) FROM ".DBPREFIX."tags WHERE id = ${_POST['id']}";
		$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		if($rows > 0){
			$sql = "SELECT no,tag FROM ".DBPREFIX."tags WHERE id = ${_POST['id']}";
			$items = $db->get_rows($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
			foreach($items as $item){	$tag_old_arr[$item['no']] = $item['tag']; }
		}
		while(list($no, $value) = each($tag_old_arr)){
			if(!in_array($value, $tag_arr)){
				$sql = "DELETE FROM ".DBPREFIX."tags WHERE no = ${no}";
				$result = $db->query($sql);
				if(!$result){	$status = 0;	}
			}else{
				$sql = "UPDATE ".DBPREFIX."tags SET ";
				$sql .= "status = ${_POST['flag_pub']}";
				$sql .= " WHERE no=${no}";
				$result = $db->query($sql);
				if(!$result){	$status = 0;	}
			}
		}
		if(is_array($tag_arr)){	reset($tag_arr); }
		while(list(,$value) = each($tag_arr)){
			if(!in_array($value, $tag_old_arr)){
				$line  = "NULL,${_POST['id']},'".$db->escape_string($value)."',1,${_POST['flag_pub']}";
				$sql = "INSERT INTO ".DBPREFIX."tags VALUES ($line)";
				$result = $db->query($sql);
				if(!$result){	$status = 0;	}
			}
		}
	}
	if(!$status){
		$result = $db->transaction_rollback();
		error("FAQ変更中にエラーが発生しました、LINE=".__LINE__);
	}else{
		$result = $db->transaction_commit();
	}
	$db->close();

	$msg_title = "FAQ変更しました。";
	$msg_detail = "FAQ変更しました。";
	require(PATH_TEMPLATE."finish.html");
}
#-------------#
#  全FAQ表示  #
#-------------#
function show_faq_all(){
	global $CNF;

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	foreach(array('title', 'url') as $key){	$$key = $config_arr[$key]; }

	if(isset($_GET['p']) && intval($_GET['p']) > 0){
		$pagenow = intval($_GET['p']);
	}else{
		$pagenow = 1;
	}
	$num_start = ($pagenow - 1) * $config_arr['pageview'] + 1;
	$offset = $num_start - 1;

	$sql = "SELECT count(*) FROM ".DBPREFIX."master WHERE status = 1";
	$rows_all = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	if($rows_all < $pagenow * $config_arr['pageview']){
		$num_end = $rows_all;
	}else{
		$num_end = $pagenow * $config_arr['pageview'];
	}
	foreach(array('rows_all', 'num_start', 'num_end') as $key){
		$key_new = $key . "_format";
		$$key_new = str_replace(",", "&#44;", number_format($$key));
	}

	// FAQリスト取得
	$list_faqs = get_list_faqs($db,$offset,$config_arr['faq_num'],$config_arr['click'],$_GET['mode'],$config_arr['show'],$config_arr['order']);

	$argv = t2h($_SERVER['SCRIPT_NAME'])."?mode=faq_all";
	$pageing = $num_start_format."&nbsp;-&nbsp;".$num_end_format."&nbsp;(&nbsp;".$rows_all_format."&nbsp;件中&nbsp;)<br><br>\n";
	$pages_str = get_control_pages($rows_all,$pagenow,$num_start,$num_end,"seek",$argv,$pageing,$config_arr['pageview'],$config_arr['page_control']);
	$db->close();

	$theme = "最近のエントリー";
	require(PATH_TEMPLATE."control_panel.html");
}
#------------------#
#  ログイン        #
#------------------#
function login($status=false){
	global $CNF;

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	foreach(array('title', 'url') as $key){	$$key = $config_arr[$key]; }

	// パスワードチェック
	if($status == false){
		check_pass($CNF['cookie_name'],$config_arr['pass']);
	}else{
		check_user_cookie($CNF['cookie_name'],$config_arr['pass']);
	}

	// FAQリスト取得
	$list_faqs = get_list_faqs($db,0,$config_arr['faq_num'],"0","new");

	$db->close();

	require(PATH_TEMPLATE."control_panel.html");
}
#----------------------#
#  パスワードチェック  #
#----------------------#
function check_pass($cookie_name,$pass_config){
	global $CNF;

	if(empty($_POST['pass'])){	error("パスワードが入力されていません、LINE=".__LINE__); }
	$pass_encrypted = sha1($_POST['pass']);
	// パスワード照合
	if($pass_encrypted != $pass_config){	error("パスワード：".t2h($_POST['pass'])."は違います、LINE=".__LINE__); }

	// Cookieセット
	set_user_cookie($cookie_name,$pass_encrypted,$CNF['secret_key']);
}
#----------------#
#  Cookieセット  #
#----------------#
function set_user_cookie($cookie_name,$pass_encrypted){
	global $CNF;

	if(isset($_COOKIE[$cookie_name])){	setcookie($cookie_name); }
	$ip = $_SERVER['REMOTE_ADDR'];
	$ua = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : "";
	$cookie_val = $pass_encrypted.":".sha1($ip."-".$CNF['secret_key']).":".sha1($ua."-".$CNF['secret_key']);
	if(!setcookie($cookie_name, $cookie_val)){	error("クッキー送信に失敗しました。 LINE=".__LINE__); }
}
#------------------#
#  Cookieチェック  #
#------------------#
function check_user_cookie($cookie_name,$pass){
	global $CNF;

	if(!isset($_COOKIE[$cookie_name]) || $_COOKIE[$cookie_name] == ""){
		error("クッキーを有効にしてから、もう一度ログインし直してご利用下さい、LINE=".__LINE__);
	}
	list($pass_encrypted,$ip_cookie,$ua_cookie) = explode(":", $_COOKIE[$cookie_name]);
	$ip = $_SERVER['REMOTE_ADDR'];
	if(sha1($ip."-".$CNF['secret_key']) != $ip_cookie){	error("IPアドレスの変更は許可していません、LINE=".__LINE__); }
	$ua = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : "";
	if(sha1($ua."-".$CNF['secret_key']) != $ua_cookie){	error("ユーザーエージェントの変更は許可していません、LINE=".__LINE__); }
	if($pass_encrypted != $pass){	error("パスワードが違います。もう一度ログインし直してご利用下さい、LINE=".__LINE__); }
	return $pass_encrypted;
}
#--------------#
#  Cookie削除  #
#--------------#
function delete_user_cookie($cookie_name){

	// 管理用Cookie削除
	setcookie($cookie_name);
}
#------------------#
#  ログアウト      #
#------------------#
function logout(){
	global $CNF;

	$db = new DB(DBHOST,DBUSER,DBPASS,DBNAME);

	// 環境設定詳細取得
	$config_arr = get_config_detail($db);

	foreach(array('title', 'url') as $key){	$$key = $config_arr[$key]; }

	$db->close();

	delete_user_cookie($CNF['cookie_name']);

	require(PATH_TEMPLATE."logout.html");
}
#----------------#
#  デコード処理  #
#----------------#
function decode(){

	if($_SERVER['REQUEST_METHOD'] == "GET"){	error("不正な投稿です"); }

	foreach($_POST as $key => $value){
		// バックスラッシュの排除
		if(get_magic_quotes_gpc()){	$value = stripslashes($value); }

		// タグ処理
		// 区切り文字","をタグ用に処理
		$value = str_replace(",", "&#44;", $value);
		//$value = str_replace("<>", "&lt;&gt;", $value);

		if($key == "answer"){
			$value = trim($value);
			$value = preg_replace('/(\r\n|\r|\n)/', '<br>', $value);
			$value = preg_replace('/[\0]/', '', $value);
		}elseif($key == "tag"){
			$value = strip_tags($value);
			$value = preg_replace('/[\r\n\t\0]/', '', $value);
			$value = mb_ereg_replace("(\s|　)+", " ", $value);
		}elseif($key != "order"){
			$value = strip_tags($value);
			$value = preg_replace('/[\r\n\t\0]/', '', $value);
		}
		if($key != "order"){
			$value = trim($value);
			$_POST[$key] = $value;
		}
	}
}
#------------------------------#
#  タグ（キーワード）チェック  #
#------------------------------#
function check_tags($tag_max=5,$tag_len=32){

	$tag_arr = array();
	$tag_tmp_arr = array();
	$_POST['tag'] = mb_ereg_replace("(\s|　)+", " ", trim($_POST['tag']));
	$tag_arr = split(" ", $_POST['tag']);
	$tag_arr_cnt = 0;
	while(list(,$value) = each($tag_arr)){
		if(!in_array($value, $tag_tmp_arr)){
			array_push($tag_tmp_arr, $value);
		}else{
			$value = htmlspecialchars($value);
			error("タグ（キーワード）が重複しています。「${value}」、LINE=".__LINE__);
		}
		if(mb_strlen($value, "utf-8") > $tag_len){
			$value = htmlspecialchars($value);
			error("タグ（キーワード）「${value}」は".$tag_len."文字を超えています、LINE=".__LINE__);
		}
		$tag_arr_cnt++;
	}
	if($tag_arr_cnt > $tag_max){	error("タグ（キーワード）に設定できるのは".$tag_max."個までです、LINE=".__LINE__); }
	unset($tag_tmp_arr);
	return $tag_arr;
}
?>