<?php
##======================================================##
##  共通仕様サブルーチン                                ##
##======================================================##
#--------------#
#  エラー処理  #
#--------------#
function error($msg){
	global $CNF;

$path_css = PATH_CSS;
echo <<<EOM
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html lang="ja">
<head>
<meta http-equiv="Content-Language" content="ja">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>$msg</title>
<link rel="stylesheet" href="${path_css}style.css" type="text/css">
</head>
<body>
<h4>$msg</h4>
恐れ入りますが、再度試して下さい。<hr>
前の画面に戻ってやり直す場合は、ブラウザの「戻る」ボタンを押して下さい。<hr>
<a href="javascript:history.back();">&lt;&lt;戻る</a>&nbsp;&nbsp;<a href="${CNF['main']}">ホーム</a>
</body>
</html>
EOM;
exit;
}
#----------------------#
#  ページコントロール  #
#----------------------#
function get_control_pages(&$rows_all,&$pagenow,&$num_start,&$num_end,$mode="ct",$argv="",$pageing,$pageview,$page_control){

	if($num_start == 1 && $num_end == 0){	return $str = "<p class=\"pages\">0&nbsp;-&nbsp;0&nbsp;(&nbsp;0&nbsp;件中&nbsp;)</p>"; }
	$str = "<div class=\"pages\">${pageing}";
	if($pagenow > 1){
		$page_prev = $pagenow - 1;
		$page_prev_02d = sprintf("%02d", $page_prev);
		if($page_prev >= 1){	$str .= "<a href=\"${argv}&p=${page_prev}\">&lt;&lt;Prev</a>\n"; }
	}else{
		$str .= "&lt;&lt;Prev&nbsp;\n";
	}
	// ページ出力範囲の判定
	$page_max = ceil($rows_all/$pageview);
	$pagenow_left_border = $pagenow - $page_control;
	if($pagenow_left_border >= 1){
		$page_start = $pagenow_left_border;
	}elseif($pagenow_left_border == 0){
		$page_start = $pagenow_left_border + 1;
	}elseif($pagenow_left_border == -1){
		$page_start = $pagenow_left_border + 2;
	}elseif($pagenow_left_border == -2){
		$page_start = $pagenow_left_border + 3;
	}elseif($pagenow_left_border == -3){
		$page_start = $pagenow_left_border + 4;
	}else{
		$page_start = $pagenow;
	}
	$page_end = $page_start + $page_control + 4;
	for($page_calc = $page_start; $page_calc <= $page_end; $page_calc++){
		$page_calc_02d = sprintf("%02d", $page_calc);
		$num_start_calc = ($page_calc - 1) * $pageview + 1;
		if($rows_all < $page_calc * $pageview){
			$num_end_calc = $rows_all;
		}else{
			$num_end_calc = $page_calc * $pageview;
		}
		if($page_calc <= $page_max){
			if($page_calc == $pagenow){
				$str .= "<span id=\"now\">${page_calc}</span>\n";
			}else{
				if($page_calc >= 1){	$str .= "<a href=\"${argv}&p=${page_calc}\">${page_calc}</a>\n"; }
			}
		}else{
			break;
		}
	}
	if($page_end < $page_max){	$str .= "&nbsp;…&nbsp;";	}
	if($rows_all > $num_end){
		$page_next = $pagenow + 1;
		$page_next_02d = sprintf("%02d", $page_next);
		if($page_next > 1){	$str .= "<a href=\"${argv}&p=${page_next}\">Next&gt;&gt;</a>\n"; }
	}else{
		$str .= "&nbsp;Next&gt;&gt;\n";
	}
	if(!empty($str)){	$str .= "</div>\n"; }

	return $str;
}
#--------------------#
#  環境設定詳細取得  #
#--------------------#
function get_config_detail(&$db){

	$arr = array();
	$sql = "SELECT * FROM ".DBPREFIX."config ORDER BY id";
	$items = $db->get_rows($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	foreach($items as $item){	$arr[$item['kw']] = $item['value']; }
	return $arr;
}
#-----------------#
#  FAQリスト取得  #
#-----------------#
function get_list_faqs(&$db,$offset=0,$pageview,$click=0,$mode="",$show=0,$order=1){
	global $CNF;

	$str = "";
	$target = intval($click) < 1 ? "_blank" : "_top";
	$order = intval($order) < 1 ? "" : " DESC";
	//if($offset == 0){
		$sql = "SELECT count(*) FROM ".DBPREFIX."master WHERE status = 1";
		$rows_all = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		if($rows_all == 0){	return $str; }
	//}
	$sql = "SELECT id,question FROM ".DBPREFIX."master WHERE status = 1 ORDER BY id${order} limit ${offset}, ${pageview}";
	$items = $db->get_rows($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	foreach($items as $item){
		if(intval($show) == 1){
			$str .= "<li><a href=\"${CNF['main']}?mode=faq&id=${item['id']}#${item['id']}\" target=\"${target}\">".$item['question']."</a></li>\n";
		}else{
			$str .= "<li><a href=\"${CNF['main']}?mode=faq&id=${item['id']}\" target=\"${target}\">".$item['question']."</a></li>\n";
		}
	}
	if(!empty($str)){
		if($mode != "faq_all" && $pageview < $rows_all){	$str .= "<li><div align=\"right\"><a href=\"".t2h($_SERVER["SCRIPT_NAME"])."?mode=faq_all\">もっと見る</a></div></li>\n"; }
		$str = "<ul>\n" . $str . "</ul>\n";
	}
	return $str;
}
#----------------------#
#  カテゴリリスト取得  #
#----------------------#
function get_list_top_category(&$db,$ct_cd="",$show_ct=1){
	global $CNF,$ct_name;

	$str = "";
	$ct_name = "";
	$sql = "SELECT count(*) FROM ".DBPREFIX."category WHERE ct_cd like '%0000'";
	$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	if($rows == 0){	return $str; }
	$sql = "SELECT ct_cd,ct_name FROM ".DBPREFIX."category WHERE ct_cd like '%0000' ORDER BY rank";
	$items = $db->get_rows($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	foreach($items as $item){
		if(preg_match('/^[0-9]{6}$/', $ct_cd) && $ct_cd == $item['ct_cd']){	$ct_name = $item['ct_name']; }
		if($show_ct == 1){
			$ct_target = substr($item['ct_cd'], 0, 2)."%";
			$sql = "SELECT count(*) FROM ".DBPREFIX."master WHERE ct_cd like '${ct_target}' AND status = 1";
		}else{
			$sql = "SELECT count(*) FROM ".DBPREFIX."master WHERE ct_cd = '${item['ct_cd']}' and status = 1";
		}
		$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		$rows = "(" . number_format($rows). ")";
		$str .= "<li><a href=\"${CNF['main']}?mode=ct&ct=${item['ct_cd']}\">".t2h($item['ct_name'])."</a>&nbsp;${rows}</li>\n";
	}

	if(!empty($str)){
		$str .= "<li><div align=\"right\"><a href=\"${CNF['main']}?mode=ct_all\">一覧を見る</a></div></li>\n";
		$str = "<ul>\n" . $str . "</ul>\n";
	}
	return $str;
}
#------------------#
#  タグリスト取得  #
#------------------#
function get_list_tags(&$db,$pageview,$order=1){
	global $CNF;

	$str = "";
	$arr = array();
	$cnt_tag = 0;
	$order = intval($order) < 1 ? "" : " DESC";
	$sql = "SELECT count(*) FROM ".DBPREFIX."tags WHERE status = 1";
	$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	if($rows == 0){	return $str; }
	$sql = "SELECT no,tag FROM ".DBPREFIX."tags WHERE status = 1 ORDER BY no".$order;
	$items = $db->get_rows($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	foreach($items as $item){
		if(!in_array($item['tag'], $arr)){
			$str .= "<a href=\"${CNF['main']}?mode=tag&tag=".rawurlencode($item['tag'])."\">".t2h($item['tag'])."</a>&nbsp;\n";
			array_push($arr, $item['tag']);
			$cnt_tag++;
			if($cnt_tag >= $pageview){	break; }
		}
	}
	if(!empty($str)){
		$str .= "<li><div align=\"right\"><a href=\"${CNF['main']}?mode=tag_all\">一覧を見る</a></div></li>\n";
		$str = "<ul>\n<li>\n" . $str . "</li>\n</ul>\n";
	}
	return $str;
}
#--------------------#
#  全タグリスト取得  #
#--------------------#
function get_list_tags_all(&$db,$order=1){
	global $CNF;

	$str = "";
	$arr = array();
	$order = intval($order) < 1 ? "" : " DESC";
	$sql = "SELECT count(*) FROM ".DBPREFIX."tags WHERE status = 1";
	$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	if($rows == 0){	return $str; }
	$sql = "SELECT no,tag FROM ".DBPREFIX."tags WHERE status = 1 ORDER BY no".$order;
	$items = $db->get_rows($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	foreach($items as $item){
		if(!in_array($item['tag'], $arr)){
			$str .= "<a href=\"${CNF['main']}?mode=tag&tag=".rawurlencode($item['tag'])."\">".t2h($item['tag'])."</a>&nbsp;\n";
			array_push($arr, $item['tag']);
		}
	}
	if(!empty($str)){
		$str = "<ul>\n<li>\n" . $str . "</li>\n</ul>\n";
	}
	return $str;
}
#----------------------------#
#  カテゴリ一覧（全体）取得  #
#----------------------------#
function get_list_category_all(&$db,$show_ct=1){
	global $CNF;

	$str = "";
	$sql = "SELECT count(*) FROM ".DBPREFIX."category WHERE ct_cd like '%0000' ORDER BY ct_cd";
	$rows_all = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	if($rows_all == 0){	return $str; }
	$str = <<<EOM
<table border="0" width="100%" cellspacing="1" cellpadding="5">
<tr>
<td bgcolor="#FFFFFF" width="100" align="left">
EOM;
	$sql = str_replace("count(*)", "*", $sql);
	$items = $db->get_rows($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	foreach($items as $item){
		if($show_ct == 1){
			$ct_target = substr($item['ct_cd'], 0, 2)."%";
			$sql = "SELECT count(*) FROM ".DBPREFIX."master WHERE ct_cd like '${ct_target}' AND status = 1";
		}else{
			$sql = "SELECT count(*) FROM ".DBPREFIX."master WHERE ct_cd = '${item['ct_cd']}' AND status = 1";
		}
		$rows_master = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		$str .= "・<a href=\"${CNF['main']}?mode=ct&ct=${item['ct_cd']}\">" . t2h($item['ct_name']) . "</a>&nbsp;(".number_format($rows_master).")<br>";
		$str2_4 = substr($item['ct_cd'], 2, 4);
		$str4_2 = substr($item['ct_cd'], 4, 2);
		if(intval($str2_4) == 0){
			$ct_target = substr($item['ct_cd'], 0, 2)."%00";
		}elseif(intval($str4_2) == 0){
			$ct_target = substr($item['ct_cd'], 0, 4)."%";
		}else{
			$ct_target = "";
		}
		$sql = "SELECT count(*) FROM ".DBPREFIX."category WHERE ct_cd like '${ct_target}' AND ct_cd <> '${item['ct_cd']}'";
		$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		if($rows == 0){	continue; }
		$sql = str_replace("count(*)", "*", $sql);
		$sql .= " ORDER BY ct_cd";
		$items_tmp = $db->get_rows($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		$cnt = 0;
		foreach($items_tmp as $item_tmp){
			if($show_ct == 1){
				$ct_target = substr($item_tmp['ct_cd'], 0, 4)."%";
				$sql = "SELECT count(*) FROM ".DBPREFIX."master WHERE ct_cd like '${ct_target}' AND status = 1";
			}else{
				$sql = "SELECT count(*) FROM ".DBPREFIX."master WHERE ct_cd = '${item_tmp['ct_cd']}' AND status = 1";
			}
			$rows_master = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
			$cnt++;
			if($cnt < $rows){
				$str .= "&nbsp;├&nbsp;" . "<a href=\"${CNF['main']}?mode=ct&ct=${item_tmp['ct_cd']}\">" . t2h($item_tmp['ct_name']) . "</a>&nbsp;(".number_format($rows_master).")<br>";
			}elseif($cnt == $rows){
				$str .= "&nbsp;└&nbsp;" . "<a href=\"${CNF['main']}?mode=ct&ct=${item_tmp['ct_cd']}\">" . t2h($item_tmp['ct_name']) . "</a>&nbsp;(".number_format($rows_master).")<br>";
			}
		}
		$str2_4 = substr($item_tmp['ct_cd'], 2, 4);
		$str4_2 = substr($item_tmp['ct_cd'], 4, 2);
		if(intval($str2_4) == 0){
			$ct_target = substr($item_tmp['ct_cd'], 0, 2)."%00";
		}elseif(intval($str4_2) == 0){
			$ct_target = substr($item_tmp['ct_cd'], 0, 4)."%";
		}else{
			$ct_target = "";
		}
		unset($items_tmp);
		$sql = "SELECT count(*) FROM ".DBPREFIX."category WHERE ct_cd like '${ct_target}' AND ct_cd <> '${item_tmp['ct_cd']}'";
		$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		if($rows == 0){	continue; }
		$sql = str_replace("count(*)", "*", $sql);
		$sql .= " ORDER BY ct_cd";
		$result = $db->query($sql);
		$items_tmp = $db->get_rows($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
		$cnt = 0;
		foreach($items_tmp as $item_tmp){
			$sql = "SELECT count(*) FROM ".DBPREFIX."master WHERE ct_cd = '${item_tmp['ct_cd']}' AND status = 1";
			$rows_master = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
			$cnt++;
			if($cnt < $rows){
				$str .= "&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;" . "<a href=\"${CNF['main']}?mode=ct&ct=${item_tmp['ct_cd']}\">" . t2h($item_tmp['ct_name']) . "</a><br>";
			}elseif($cnt == $rows){
				$str .= "&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;" . "<a href=\"${CNF['main']}?mode=ct&ct=${item_tmp['ct_cd']}\">" . t2h($item_tmp['ct_name']) . "</a><br>";
			}
		}
	}
	if(!empty($str)){
		$str .= <<<EOM
</td></tr></table>\n
EOM;
	}
	return $str;
}
#------------------#
#  カテゴリ名取得  #
#------------------#
function get_name_category(&$db,$ct_cd){

	$sql = "SELECT count(*) FROM ".DBPREFIX."category WHERE ct_cd = '${ct_cd}'";
	$rows = $db->get_count($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	if($rows == 0){	return ""; }
	$sql = "SELECT ct_name FROM ".DBPREFIX."category WHERE ct_cd = '${ct_cd}'";
	$item = $db->fetch_array_assoc($sql,$_SERVER['SCRIPT_NAME'],__FUNCTION__,__LINE__);
	return $item['ct_name'];
}
#---------------------------------#
#  著作権表示出力(改変/削除不可)  #
#---------------------------------#
function show_copyright(){
	global $copyright;

	echo $copyright;
}
#----------------#
#  TEXT -> HTML  #
#----------------#
function t2h($str){

	$str = htmlspecialchars($str, ENT_QUOTES);
	$str = str_replace(",", "&#44;", $str);
	$str = str_replace("\r\n", "<br>", $str);
	$str = str_replace("\r", "<br>", $str);
	$str = str_replace("\n", "<br>", $str);
	return $str;
}
#----------------#
#  HTML -> TEXT  #
#----------------#
function h2t($str){

	$str = str_replace("&amp;", "&", $str);
	$str = str_replace("&quot;", "\"", $str);
	$str = str_replace("&#39;", "'", $str);
	$str = str_replace("&lt;", "<", $str);
	$str = str_replace("&gt;", ">", $str);
	$str = str_replace("&#44;", ",", $str); // 区切り文字を元に戻す
	$str = str_replace("<br>", "\n", $str);
    	return $str;
}
?>