<?php
##======================================================##
##  365 FAQ デフォルト設定ファイル                      ##
##  Copyright (C) php365.com All rights reserved.       ##
##  http://php365.com/                                  ##
##======================================================##
// ↓ライブラリパス
define("PATH_LIB", "lib/");
// ↓スタイルシート用パス
define("PATH_CSS", "css/");
// ↓javascript用パス
define("PATH_JS", "js/");
// ↓データベースパス（データベースタイプ：SQLite2 or SQLite3の場合のみ使用）
define("PATH_DB", "db/");
// ↓スタイルシート用パス
define("PATH_TEMPLATE", "tmpl/");

// データベースタイプ（1=MySQL、2=SQLite2(デフォルト)、3=SQLite3）
define("DBTYPE", 2);
// 接続するホスト名とポート番号
define("DBHOST", "localhost");
// データベース名、ユーザー名、パスワード（必ず修正）
define("DBNAME", "php365faq.db");	// データベース名
define("DBUSER", "");	// ユーザー名（MySQLの場合のみ設定必要）
define("DBPASS", "");	// パスワード（MySQLの場合のみ設定必要）
define("DBPREFIX", "php365faq_");	// テーブル名の最初に追加する共通の文字列

$CNF = array(
// 環境設定
'pass' => "setup",	// 管理用パスワード
'cookie_name' => "php365faqc",	// 管理用Cookie名
'secret_key' => "ajd6aq2XALYmJ6aYlDSc47dU7ARuAVn0", // Secret Key（接続元IP・ユーザーエージェント照合用(半角英数32文字)
'main' => "index.php",	// 365 FAQのメインスクリプト名
'search' => "search.php", // 検索用スクリプト名
'admin' => "admin.php",	// コントロールパネル管理用スクリプト名
// ↓以下の項目は
'title' => "365 FAQ",	// ホームの名称
'url' => "http://www.zzz.zzz/", // ホームのURL
'flag_html' => "1",	// 答え欄のHTMLタグ使用設定（0=使用しない、1=使用する）
'pageview' => "10",	// 1ページに表示するFAQデータ件数
'faq_num' => "20",	// 1ページに表示するFAQリスト件数
'tag_num' => "20",	// 1ページに表示するタグ(キーワード)件数
'page_control' => "5",	// 改ページコントロール出力範囲（現在のページから出力する範囲を整数で指定）
'order' => "1",		// データの表示順序（0=古い順、1=新しい順）
'show' => "1",		// データ表示方法（0=各FAQ毎に表示、1=カテゴリ毎に表示）
'show_ct' => "1",	// カテゴリデータの表示方法（0=各カテゴリ毎に表示、1=下の階層のカテゴリも含めて表示）
'click' => "1",		// 各FAQリンクをクリックした時の表示方法（0=別ウィンドウに表示、1=同一ウィンドウに表示）
'order_tag' => "1",	// タグ(キーワード)の表示順序（0=古い順、1=新しい順）
'tag_max' => "5",	// FAQ毎に設定できるタグ(キーワード)の個数
'tag_len' => "16",	// FAQ毎に設定できるタグ(キーワード)に設定できる最大文字数（全角文字換算）
'flag_referer' => "1",	// 検索する時にリファラチェックするかどうか（0=しない(他サイトからも検索可能)、1=する(自サイトからのみ検索可能)）
'version' => "1.00",	// 365 FAQ バージョン
);
// ↓地域時間設定（タイムゾーン：使用する地域のグリニッジ標準時間との時差。）
// ↓単位：時間(hour)単位、マイナス指定可
$timezone = 9;
// ------------- 設定ここまで -------------
// 環境設定の説明分
$CNF_detail = array(
'title' => "ホームのタイトル",
'url' => "ホームのURL",
'pageview' => "1ページに表示するFAQデータ件数",
'faq_num' => "1ページに表示するFAQリスト件数",
'tag_num' => "1ページに表示するタグ(キーワード)件数",
'page_control' => "改ページコントロール出力範囲",
'tag_max' => "タグ(キーワード)の最大数",
'tag_len' => "タグ(キーワード)に設定できる最大文字数",
);
switch(DBTYPE):
	case '1':
		define("DBSTR", "mysql");
		break;
	case '2':
		define("DBSTR", "sqlite2");
		break;
	case '3':
		define("DBSTR", "sqlite3");
		break;
	default:
		header("Content-Type: text/html;charset=utf-8");
		echo "データベースタイプに誤りがあります。config.phpの設定を確認して下さい。";exit;
		break;
endswitch;
error_reporting(0);
// ↓著作権表示(改変/削除不可)
$copyright = "- <a href=\"http://php365.com/\" target=\"_top\">365 FAQ Ver1.03</a> -\n";
?>