<?php
##======================================================##
##  365 MailForm                                        ##
##  Copyright (C) php365.com All rights reserved.       ##
##  http://php365.com/                                  ##
##======================================================##
// 設定ライブラリ
require_once("./lib/config.php");
// 共通仕様サブルーチン
require_once("./lib/common.php");

#==============#
#  メイン処理  #
#==============#
check_host();

switch($_SERVER['REQUEST_METHOD']):
	case 'GET':
		//if(!isset($_GET['mode'])){	error("不正なリクエストです、LINE=".__LINE__);exit; }
		if(isset($_GET['mode'])){
			if($_GET['mode'] == "check"){
				check();
			}else{
				error("不正なリクエストです、LINE=".__LINE__);
			}
		}else{
			make_top_page();	// トップページ作成
		}
		break;
	case 'POST':
		if(!isset($_POST['mode'])){	error("不正なリクエストです、LINE=".__LINE__);exit; }
		switch($_POST['mode']):
			case 'do_form':
			$name_old = $_POST['name'];
			$comment_old = $_POST['comment'];
			decode();
			check_input();
			show_html_confirm($name_old,$comment_old);
			break;
		case 'do_form2':
			decode();
			check_input();
			show_html_finish();
			break;
		default:
			error("不正なリクエストです、LINE=".__LINE__);
			break;
		endswitch;
		break;
	default:
		error("不正なリクエストです、LINE=".__LINE__);
		break;
endswitch;
exit;
#--------------------#
#  トップページ作成  #
#--------------------#
function make_top_page(){
	global $SPAM,$homeurl,$title,$copyright;

	$name_chk = NAME_FLG ?		MARK : "";
	$email_chk = EMAIL_FLG ?	MARK : "";
	$comment_chk = COMMENT_FLG ?	MARK : "";
	if($SPAM['js']){
		$path_parts = pathinfo($homeurl);
		$dirname = $path_parts['dirname'] . "/";
		$script = $_SERVER['SCRIPT_NAME'];
		foreach(array('dirname','script','title') as $key){
			$key_new = $key . "4html";
			$$key_new = t2h($$key);
		}
		$template = "./tmpl/index4js.html";
	}else{
		$script4html = t2h($_SERVER['SCRIPT_NAME']);
		$title4html = t2h($title);
		$template = "./tmpl/index4notjs.html";
	}
	// トップページ作成開始
	if(file_exists(TOPPAGE)){
		$filemode = "r+";
		$flag_chmod = 1;
	}else{
		$filemode = "w";
		$flag_chmod = 0;
	}
	$fp = @fopen(TOPPAGE, $filemode) or error("fopen Error: ".TOPPAGE);
	// ロック開始
//	flock($fp, LOCK_EX);
	// 書き込みバッファを 0 にする
	set_file_buffer($fp, 0);
	if($flag_chmod){	ftruncate($fp, 0); }
	rewind($fp);
	$data = file($template);
	//while(list($key, $value) = each($data)){
	foreach($data as $value){
		foreach(array('title','dirname4html','script4html','title4html','script4html','name_chk',
		'email_chk','comment_chk','homeurl','copyright','noscript') as $k){
			$value = str_replace("<!-- $k -->", $$k, $value);
		}
		$value = str_replace("<!-- MARK -->", MARK, $value);
		fputs($fp, $value);
	}
	// ロック解除
//	flock($fp, LOCK_UN);
	fclose($fp);
	if(!$flag_chmod){	chmod(TOPPAGE, 0606); }

	# メールフォーム作成完了メッセージ出力
	$msg = "現在の設定でメールフォームを作成しました。<p><a href=\"".TOPPAGE."\">メールフォームURL</a></p>";
	finish($msg);
}
#--------------------#
#  入力確認画面表示  #
#--------------------#
function show_html_confirm($name_old,$comment_old){
	global $SPAM,$REG,$homeurl,$title,$script,$copyright;

	foreach(array('name_old', 'comment_old') as $key){
		$$key = preg_replace('/"/', '&quot;', $$key);
	}

	set_tracking();
	set_session();

	$name_chk = NAME_FLG ?		MARK : "";
	$email_chk = EMAIL_FLG ?	MARK : "";
	$comment_chk = COMMENT_FLG ?	MARK : "";
	if(isset($_POST['copy']) && $_POST['copy'] == "on"){
		$copy_flg = "コピーをEmailで受信する";
	}else{
		$copy_flg = "コピーをEmailで受信しない";
	}
	if($SPAM['js']){
		$path_parts = pathinfo($homeurl);
		$dirname = $path_parts['dirname'] . "/";
		$script = $_SERVER['SCRIPT_NAME'];
		require("./tmpl/confirm4js.html");
	}else{
		require("./tmpl/confirm4notjs.html");
	}
}
#--------------------#
#  最後のメッセージ  #
#--------------------#
function show_html_finish(){
	global $REG,$homeurl;

	check_referer();
	check_tracking();
	check_session();

	// 認証キーチェック
	if($REG['check']){
		if(empty($_POST['regkey'])){	error("認証キーを入力して下さい。"); }
		if(!preg_match('/^[0-9]{4}$/', $_POST['regkey'])){	error("認証キーには指定された数字を入力して下さい。"); }

		// 認証キー用サブルーチン
		require_once("./lib/reglib.php");

		$encrypted = rawurldecode($_POST['encrypted']);
		$decrypted = decode_regkey($encrypted);
		$err_msg = check_regkey($decrypted);
		if(!empty($err_msg)){	error($err_msg); }
	}

	sendmail();
	$msg_title = "メール送信完了";
	$msg_details = "メール送信完了しました。";
	require("./tmpl/finish.html");
}
#----------------#
#  入力チェック  #
#----------------#
function check_input(){
	global $SPAM;

	# フォーム内容をチェック
	if(NAME_FLG && $_POST['name'] == ""){ error("名前が入力されていません"); }
	if(EMAIL_FLG){
		if(!$_POST['email']){ error("Emailが入力されていません"); }
		elseif(!preg_match('/^[\w.-]+\@[\w.-]+\.[a-zA-Z]{2,7}$/', $_POST['email'])){ error("Emailの入力内容が正しくありません"); }
	}
	if(COMMENT_FLG && $_POST['comment'] == ""){ error("コメントが入力されていません"); }
	if(!$SPAM['single'] && !preg_match('/[\xc0-\xf7][\x80-\xbf]/', $_POST['comment'])){	error("半角文字のみの投稿は禁止しています"); }
	if(!$SPAM['url'] && preg_match('/http:\/\//', $_POST['comment'])){	error("URLを含む投稿は禁止しています。<br>どうしてもURLを投稿した場合は、頭の「h」を除いた「ttp://」から始めるようにして再度投稿して下さい。"); }

	// NGワードチェック
	if(NG_WORD != ""){	check_ng_word(array('name','comment')); }
	// NGURLチェック
	if(NG_URL != ""){	check_ng_url(array('name','comment')); }
}
#----------------#
#  デコード処理  #
#----------------#
function decode() {

	if($_SERVER['REQUEST_METHOD'] == "GET"){	error("不正な投稿です"); }

	foreach($_POST as $key => $value){
		// バックスラッシュの排除
		//if(get_magic_quotes_gpc()){	$value = stripslashes($value); }

		$value = strip_tags($value);
		$value = preg_replace('/\0/', '', $value);
		$value = preg_replace('/(　| )+/', ' ', $value);
		if($key == "name" || $key == "comment"){
			if($_POST['mode'] == "do_form2"){
				$value = preg_replace('/&quot;/', '"', $value);
			}
		}
		$value = trim($value);

		$_POST[$key] = $value;
	}

}
#--------------#
#  メール送信  #
#--------------#
function sendmail(){

	$agent = getenv("HTTP_USER_AGENT");
	$host = getenv("REMOTE_HOST");
	$addr = getenv("REMOTE_ADDR");
	if($host == "" || $host == $addr){	$host = @gethostbyaddr($addr);	}
	$date = gmdate("Y/m/d H:i:s (D)",time()+9*60*60);

$mailbody = <<<EOM
------------------------------------------------------------
投稿時間：$date
登録者のIPアドレス：$addr
登録者のホスト名：$host
登録者のブラウザ：$agent

名前		：{$_POST['name']}
E-Mail		：{$_POST['email']}
コメント：
{$_POST['comment']}
------------------------------------------------------------
EOM;

	mb_language("japanese");
	mb_internal_encoding("UTF-8");
	$headers = "From: ".$_POST['email']."\r\n";
	if($_POST['copy'] == "on"){
		$headers .= "Bcc: ".$_POST['email']."\r\n";
	}
	$rcode = @mb_send_mail(MAILTO, SUBJECT, $mailbody, $headers);

	if(!$rcode){	error("メール送信エラー");	}
}
?>