<?php
#----------------------------#
#  暗号管理クラス（OpenSSL） #
#----------------------------#
class CodeOpenSSL{

	private string $seed;	// 暗号化に使うシード値
	private string $cipher;
	private string $encrypted;
	private string $decrypted;

	// コンストラクタ
	function __construct(string $pass, string $seed, string $cipher){
		$this->cipher = $cipher;
		for($i = 0, $this->seed = ""; $i < strlen($pass); $i++){
			$this->seed .= strpos($seed, $pass[$i]);
		}
	}

	// 暗号化
	function EncOpenSSL(string $id){
		$this->encrypted = openssl_encrypt($id, $this->cipher, $this->seed);
		return trim($this->encrypted);
	}
	// 復号化
	function DecOpenSSL(string $encrypted){
		$this->decrypted = openssl_decrypt($encrypted, $this->cipher, $this->seed);
		return trim($this->decrypted);
	}
}
#------------------------#
#  暗号管理クラス（XOR） #
#------------------------#
class CodeXOR{

	private string $seed;	// 暗号化に使うシード値
	private int $len_id;
	private int $len_seed;
	private string $encrypted;
	private string $decrypted;

	// コンストラクタ
	function __construct(string $pass, string $seed){
		for($i = 0, $this->seed = ""; $i < strlen($pass); $i++){
			$this->seed .= strpos($seed, $pass[$i]);
		}
	}
	// 暗号化
	function EncXOR(string $id){
		$this->len_id = strlen($id);
		$this->len_seed = strlen($this->seed);
		if($this->len_id > $this->len_seed){
			for($i = 1; $i <= $this->len_id - $this->len_seed; $i++){
				$this->seed .= "0";
			}
		}elseif($this->len_id < $this->len_seed){
			$this->seed = substr($this->seed, 0, $this->len_id);
		}
		$this->encrypted = $id ^ $this->seed;
		return $this->encrypted . "&" . (string)$this->len_id;
	}
	// 復号化
	function DecXOR(string $encrypted){
		if(!preg_match('/&[0-9]+$/', $encrypted)){	return $this->decrypted = ""; }
		list($encrypted,$this->len_id) = explode("&", $encrypted);
		$this->len_seed = strlen($this->seed);
		if($this->len_id > $this->len_seed){
			for($i = 1; $i <= $this->len_id - $$this->len_seed; $i++){
				$this->seed .= "0";
			}
		}elseif($this->len_id < $this->len_seed){
			$this->seed = substr($this->seed, 0, $this->len_id);
		}
		$this->decrypted = $encrypted ^ $this->seed;
		return $this->decrypted;
	}
}
#---------------------------#
#  暗号管理クラス（AddSub） #
#---------------------------#
class CodeAddSub{

	private string $seed;	// 暗号化に使うシード値
	private int $len_id;
	private int $len_seed;
	private string $encrypted;
	private string $decrypted;

	// コンストラクタ
	function __construct(string $pass, string $seed){
		for($i = 0, $this->seed = ""; $i < strlen($pass); $i++){
			$this->seed .= strpos($seed, $pass[$i]);
		}
	}
	// 暗号化
	function EncAddSub(string $id){
		$this->len_id = strlen($id);
		$this->len_seed = strlen($this->seed);
		if($this->len_id > $this->len_seed){
			for($i = 1; $i <= $this->len_id - $this->len_seed; $i++){
				$this->seed .= "0";
			}
		}elseif($this->len_id < $this->len_seed){
			$this->seed = substr($this->seed, 0, $this->len_id);
		}
		$this->encrypted = bcadd($id, $this->seed);
		return $this->encrypted . "&" . (string)$this->len_id;
	}
	// 復号化
	function DecAddSub(string $encrypted){
		if(!preg_match('/^[0-9]+&[0-9]+$/', $encrypted)){	return $this->decrypted = ""; }
		list($encrypted,$this->len_id) = explode("&", $encrypted);
		$this->len_seed = strlen($this->seed);
		if($this->len_id > $this->len_seed){
			for($i = 1; $i <= $this->len_id - $this->len_seed; $i++){
				$this->seed .= "0";
			}
		}elseif($this->len_id < $this->len_seed){
			$this->seed = substr($this->seed, 0, $this->len_id);
		}
		$this->decrypted = bcsub($encrypted, $this->seed);
		return $this->decrypted;
	}
}
#----------------#
#  認証キー作成  #
#----------------#
function make_regkey(){
	global $REG;

	mt_srand((double)microtime()*1000000);
	$id = sprintf('%04d', mt_rand(0, 9999)) . time();

	// 暗号化
	if($REG['check']){
		switch($REG['crypt']):
			case '0':	// XOR
				$cd = new CodeXOR($REG['pass'],$REG['seed']);
				$encrypted = $cd->EncXOR($id);
				break;
			case '1':	// OpenSSL
				$cd = new CodeOpenSSL($REG['pass'],$REG['seed'],$REG['cipher']);
				$encrypted = $cd->EncOpenSSL($id);
				break;
			case '2':	// AddSub
				$cd = new CodeAddSub($REG['pass'],$REG['seed']);
				$encrypted = $cd->EncAddSub($id);
				break;
			default:
				$encrypted = "";
				break;
		endswitch;
	}else{
		$encrypted = "";
	}
	if(!empty($encrypted)){	$encrypted = encode_url_raw($encrypted); }
	return $encrypted;
}
#----------------#
#  認証キー復号  #
#----------------#
function decode_regkey($encrypted){
	global $REG;

	// 復号化
	if($REG['check']){
		switch($REG['crypt']):
			case '0':	// XOR
				$cd = new CodeXOR($REG['pass'],$REG['seed']);
				$decrypted = $cd->DecXOR($encrypted);
				break;
			case '1':	// OpenSSL
				$cd = new CodeOpenSSL($REG['pass'],$REG['seed'],$REG['cipher']);
				$decrypted = $cd->DecOpenSSL($encrypted);
				break;
			case '2':	// AddSub
				$cd = new CodeAddSub($REG['pass'],$REG['seed']);
				$decrypted = $cd->DecAddSub($encrypted);
				break;
			default:
				$decrypted = "";
				break;
		endswitch;
	}else{
		$decrypted = "";
	}
	return $decrypted;
}
#--------------------#
#  認証キーチェック  #
#--------------------#
function check_regkey($decrypted){
	global $REG;

	$err_msg = "";
	if($REG['check']){
		// 認証キー方式
		$regkey_master = substr($decrypted, 0, 4);
		$regkey_time = substr($decrypted, 4);
		// 入力データチェック
		if($_POST['regkey'] == $regkey_master){
			$interval = time() - $regkey_time;
			if($interval > $REG['expire'] * 60){
				$err_msg = "認証キーの有効期限が過ぎました。<br>投稿フォームを再度表示して、指定された数字を入力して下さい。";
			}
		}else{
			$err_msg = "認証キーが不正です。<br>投稿フォームを再度表示して、指定された数字を入力して下さい。";
		}
	}
	return $err_msg;
}
?>